/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.identity.mem;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.databene.jdbacl.identity.IdentityModel;
import org.databene.jdbacl.identity.KeyMapper;
import org.databene.jdbacl.identity.mem.TargetTableMapper;
import org.databene.jdbacl.model.Database;

public class TargetDatabaseMapper {
    KeyMapper root;
    Connection target;
    String targetDbId;
    Database database;
    Map<String, TargetTableMapper> tableMappers;

    public TargetDatabaseMapper(KeyMapper root, Connection target, String targetDbId, Database database) {
        this.root = root;
        this.target = target;
        this.targetDbId = targetDbId;
        this.database = database;
        this.tableMappers = new HashMap<String, TargetTableMapper>(500);
    }

    public String getDbId() {
        return this.targetDbId;
    }

    public void store(IdentityModel identity, String naturalKey, Object targetPK) {
        this.getOrCreateTableMapper(this.target, this.targetDbId, identity).store(targetPK, naturalKey);
    }

    public String getNaturalKey(IdentityModel identity, Object sourcePK) {
        return this.getOrCreateTableMapper(this.target, this.targetDbId, identity).getNaturalKey(sourcePK);
    }

    public Object getTargetPK(IdentityModel identity, String naturalKey) {
        return this.getOrCreateTableMapper(this.target, this.targetDbId, identity).getTargetId(naturalKey);
    }

    private TargetTableMapper getOrCreateTableMapper(Connection target, String targetDbId, IdentityModel identity) {
        String tableName = identity.getTableName();
        TargetTableMapper result = this.tableMappers.get(tableName);
        if (result == null) {
            result = new TargetTableMapper(this.root, target, targetDbId, identity, this.database);
            this.tableMappers.put(tableName, result);
        }
        return result;
    }
}

