/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.identity.mem;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.databene.jdbacl.identity.IdentityModel;
import org.databene.jdbacl.identity.KeyMapper;
import org.databene.jdbacl.identity.mem.SourceTableMapper;
import org.databene.jdbacl.model.Database;

public class SourceDatabaseMapper {
    KeyMapper root;
    Connection connection;
    String dbId;
    Map<String, SourceTableMapper> tableMappers;
    Database database;

    public SourceDatabaseMapper(KeyMapper root, Connection connection, String dbId, Database database) {
        this.root = root;
        this.connection = connection;
        this.dbId = dbId;
        this.database = database;
        this.tableMappers = new HashMap<String, SourceTableMapper>(500);
    }

    public void store(IdentityModel table, Object sourcePK, String naturalKey, Object targetPK) {
        this.getOrCreateTableMapper(table).store(sourcePK, naturalKey, targetPK);
    }

    public Object getTargetPK(IdentityModel table, Object sourcePK) {
        return this.getOrCreateTableMapper(table).getTargetPK(sourcePK);
    }

    public String getNaturalKey(IdentityModel identity, Object sourcePK) {
        return this.getOrCreateTableMapper(identity).getNaturalKey(sourcePK);
    }

    private SourceTableMapper getOrCreateTableMapper(IdentityModel identity) {
        String tableName = identity.getTableName();
        SourceTableMapper mapper = this.tableMappers.get(tableName);
        if (mapper == null) {
            mapper = new SourceTableMapper(this.root, this.connection, this.dbId, identity, this.database);
            this.tableMappers.put(tableName, mapper);
        }
        return mapper;
    }
}

