/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.identity.mem;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.databene.commons.ConfigurationError;
import org.databene.jdbacl.identity.IdentityModel;
import org.databene.jdbacl.identity.IdentityProvider;
import org.databene.jdbacl.identity.KeyMapper;
import org.databene.jdbacl.identity.mem.SourceDatabaseMapper;
import org.databene.jdbacl.identity.mem.TargetDatabaseMapper;
import org.databene.jdbacl.model.Database;

public class MemKeyMapper
extends KeyMapper {
    TargetDatabaseMapper targetDBMapper;
    private Database database;
    private Map<String, SourceDatabaseMapper> sourceDBMappers = new HashMap<String, SourceDatabaseMapper>();

    public MemKeyMapper(Connection source, String sourceDbId, Connection target, String targetDbId, IdentityProvider identityProvider, Database database) {
        super(identityProvider);
        this.setTarget(target, targetDbId);
        this.createSourceDBMapper(source, sourceDbId);
        this.database = database;
    }

    public void store(String sourceDbId, IdentityModel identity, String naturalKey, Object sourcePK, Object targetPK) {
        if (targetPK != null) {
            this.getTargetDBMapper().store(identity, naturalKey, targetPK);
        }
        this.getSourceDBMapper(sourceDbId).store(identity, sourcePK, naturalKey, targetPK);
    }

    public Object getTargetPK(String sourceDbId, IdentityModel table, Object sourcePK) {
        return this.getSourceDBMapper(sourceDbId).getTargetPK(table, sourcePK);
    }

    public String getNaturalKey(String dbId, IdentityModel identity, Object sourcePK) {
        if (this.targetDBMapper != null && dbId.equals(this.targetDBMapper.getDbId())) {
            return this.getTargetDBMapper().getNaturalKey(identity, sourcePK);
        }
        return this.getSourceDBMapper(dbId).getNaturalKey(identity, sourcePK);
    }

    public Object getTargetPK(IdentityModel table, String naturalKey) {
        return this.getTargetDBMapper().getTargetPK(table, naturalKey);
    }

    private TargetDatabaseMapper getTargetDBMapper() {
        if (this.targetDBMapper == null) {
            throw new ConfigurationError("'target' is undefined. Use MemKeyMapper.setTarget() to register the target database");
        }
        return this.targetDBMapper;
    }

    private void setTarget(Connection target, String targetDbId) {
        if (this.targetDBMapper == null) {
            this.targetDBMapper = new TargetDatabaseMapper(this, target, targetDbId, this.database);
        } else if (!this.targetDBMapper.getDbId().equals(targetDbId)) {
            throw new ConfigurationError("'target' has already been set to a different database: " + this.targetDBMapper.getDbId());
        }
    }

    public void registerSource(String sourceDbId, Connection connection) {
        SourceDatabaseMapper mapper = this.sourceDBMappers.get(sourceDbId);
        if (mapper == null) {
            mapper = new SourceDatabaseMapper(this, connection, sourceDbId, this.database);
            this.sourceDBMappers.put(sourceDbId, mapper);
        }
    }

    private void createSourceDBMapper(Connection connection, String sourceDbId) {
        String sourceId = sourceDbId;
        SourceDatabaseMapper mapper = new SourceDatabaseMapper(this, connection, sourceDbId, this.database);
        this.sourceDBMappers.put(sourceId, mapper);
    }

    private SourceDatabaseMapper getSourceDBMapper(String sourceId) {
        SourceDatabaseMapper mapper = this.sourceDBMappers.get(sourceId);
        if (mapper == null) {
            throw new RuntimeException("Database not registered: " + sourceId);
        }
        return mapper;
    }
}

