/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.identity;

import org.databene.commons.ConfigurationError;
import org.databene.jdbacl.SQLUtil;
import org.databene.jdbacl.identity.IdentityModel;
import org.databene.jdbacl.identity.IdentityProvider;
import org.databene.jdbacl.identity.KeyMapper;
import org.databene.jdbacl.model.DBForeignKeyConstraint;
import org.databene.jdbacl.model.DBRow;
import org.databene.jdbacl.model.DBTable;

public class SimpleTranscoder {
    public static DBRow transcode(DBRow row, String nk, Object newPK, String sourceDbId, IdentityProvider identityProvider, KeyMapper mapper) {
        DBTable table = row.getTable();
        String tableName = table.getName();
        IdentityModel identity = identityProvider.getIdentity(tableName);
        if (identity == null) {
            throw new ConfigurationError("No identity defined for table " + tableName);
        }
        mapper.store("s", identity, nk, row.getPKValue(), newPK);
        row.setPKValue(newPK);
        for (DBForeignKeyConstraint fk : table.getForeignKeyConstraints()) {
            String sourceRefNK;
            String refereeTable = fk.getRefereeTable().getName();
            Object sourceRef = row.getFKValue(fk);
            if (sourceRef == null) continue;
            IdentityModel sourceTable = identityProvider.getIdentity(refereeTable);
            Object targetRef = mapper.getTargetPK(sourceTable, sourceRefNK = mapper.getNaturalKey(sourceDbId, sourceTable, sourceRef));
            if (targetRef == null) {
                String message = "No mapping found for " + sourceDbId + '.' + refereeTable + "#" + sourceRef + " referred in " + table.getName() + SQLUtil.renderColumnNames(fk.getColumnNames()) + ". " + "Probably has not been in the result set of the former '" + refereeTable + "' nk query.";
                throw new RuntimeException(message);
            }
            row.setFKValue(fk, targetRef);
        }
        return row;
    }
}

