/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.identity;

import java.sql.Connection;
import org.databene.commons.ArrayUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.iterator.TabularIterator;
import org.databene.jdbacl.identity.IdentityModel;
import org.databene.jdbacl.identity.KeyMapper;
import org.databene.jdbacl.model.Database;

public class NaturalPkIdentity
extends IdentityModel {
    public NaturalPkIdentity(String tableName) {
        super(tableName);
    }

    public TabularIterator createNkPkIterator(Connection connection, String dbId, KeyMapper mapper, Database database) {
        String[] pkColumnNames = database.getTable(this.tableName).getPKColumnNames();
        if (ArrayUtil.isEmpty((Object)pkColumnNames)) {
            throw new ConfigurationError("Table '" + this.tableName + "' has no primary key");
        }
        StringBuilder builder = new StringBuilder("select ");
        builder.append(pkColumnNames[0]);
        for (int i = 1; i < pkColumnNames.length; ++i) {
            builder.append(" || '|' || ").append(pkColumnNames[i]);
        }
        for (String pkColumnName : pkColumnNames) {
            builder.append(", ").append(pkColumnName);
        }
        builder.append(" from ").append(this.tableName);
        String query = builder.toString();
        return this.query(query, connection);
    }

    public String getDescription() {
        return this.tableName + " identity by primary key";
    }
}

