/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.identity;

import org.databene.commons.ObjectNotFoundException;
import org.databene.commons.collection.OrderedNameMap;
import org.databene.jdbacl.identity.IdentityModel;
import org.databene.jdbacl.identity.NoIdentity;

public class IdentityProvider {
    private OrderedNameMap<IdentityModel> identities = OrderedNameMap.createCaseIgnorantMap();

    public IdentityModel getIdentity(String tableName) {
        return this.getIdentity(tableName, true);
    }

    public IdentityModel getIdentity(String tableName, boolean required) {
        IdentityModel result = (IdentityModel)this.identities.get(tableName);
        if (required && (result == null || result instanceof NoIdentity)) {
            throw new ObjectNotFoundException("No identity defined for table '" + tableName + "'");
        }
        return result;
    }

    public void registerIdentity(IdentityModel identity, String tableName) {
        this.identities.put(tableName, (Object)identity);
    }
}

