/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.dialect;

import java.util.regex.Pattern;
import org.databene.commons.StringUtil;
import org.databene.jdbacl.DatabaseDialect;
import org.databene.jdbacl.sql.Query;

public class SqlServerDialect
extends DatabaseDialect {
    private static final String DATE_PATTERN = "''yyyy-MM-dd''";
    private static final String TIME_PATTERN = "''HH:mm:ss''";
    private static final String DATETIME_PATTERN = "''yyyy-MM-dd'T'HH:mm:ss''";
    Pattern randomNamePattern = Pattern.compile("SYS_\\w*");

    public SqlServerDialect() {
        super("sql_server", false, false, DATE_PATTERN, TIME_PATTERN, DATETIME_PATTERN);
    }

    public boolean isDefaultCatalog(String catalog, String user) {
        return true;
    }

    public boolean isDefaultSchema(String schema, String user) {
        return "DBO".equalsIgnoreCase(schema);
    }

    public boolean isDeterministicPKName(String pkName) {
        return !this.randomNamePattern.matcher(pkName).matches();
    }

    public boolean isDeterministicUKName(String pkName) {
        return !this.randomNamePattern.matcher(pkName).matches();
    }

    public boolean isDeterministicFKName(String pkName) {
        return !this.randomNamePattern.matcher(pkName).matches();
    }

    public boolean isDeterministicIndexName(String indexName) {
        return !this.randomNamePattern.matcher(indexName).matches();
    }

    public String renderCase(String columnName, String elseExpression, String ... whenThenExpressionPairs) {
        StringBuilder builder = new StringBuilder();
        builder.append(columnName).append(" = ");
        builder.append("CASE");
        for (int i = 0; i < whenThenExpressionPairs.length; i += 2) {
            builder.append(" WHEN ").append(whenThenExpressionPairs[i]);
            builder.append(" THEN ").append(whenThenExpressionPairs[i + 1]);
        }
        if (!StringUtil.isEmpty((CharSequence)elseExpression)) {
            builder.append(" ELSE ").append(elseExpression);
        }
        builder.append(" END");
        return builder.toString();
    }

    public void restrictRownums(int firstRowIndex, int rowCount, Query query) {
        throw new UnsupportedOperationException("SqlServerDialect.applyRownumRestriction() is not implemented");
    }
}

