/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.dialect;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.databene.commons.ArrayBuilder;
import org.databene.commons.CollectionUtil;
import org.databene.commons.NameUtil;
import org.databene.commons.OrderedMap;
import org.databene.commons.StringUtil;
import org.databene.commons.converter.TimestampFormatter;
import org.databene.jdbacl.DBUtil;
import org.databene.jdbacl.DatabaseDialect;
import org.databene.jdbacl.model.DBCheckConstraint;
import org.databene.jdbacl.model.DBPackage;
import org.databene.jdbacl.model.DBProcedure;
import org.databene.jdbacl.model.DBSchema;
import org.databene.jdbacl.model.DBSequence;
import org.databene.jdbacl.model.DBTrigger;
import org.databene.jdbacl.sql.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDialect
extends DatabaseDialect {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleDialect.class);
    private static final String DATE_PATTERN = "'to_date('''yyyy-MM-dd''', ''yyyy-mm-dd'')'";
    private static final String TIME_PATTERN = "'to_date('''HH:mm:ss''', ''HH24:mi:ss'')'";
    private static final String DATETIME_PATTERN = "'to_date('''yyyy-MM-dd HH:mm:ss''', ''yyyy-mm-dd HH24:mi:ss'')'";
    private static final String TIMESTAMP_MESSAGE = "to_timestamp(''{0}'', ''yyyy-mm-dd HH24:mi:ss.FF'')";
    private static final String TIMESTAMP_PATTERN = "yyyy-MM-dd HH:mm:ss.SSSSSSSSS";
    private static final Pattern SIMPLE_NOT_NULL_CHECK = Pattern.compile("\"[A-Z0-9_]+\" IS NOT NULL");
    Pattern randomNamePattern = Pattern.compile("SYS_C\\d{8}");

    public OracleDialect() {
        super("oracle", true, true, DATE_PATTERN, TIME_PATTERN, DATETIME_PATTERN);
    }

    @Override
    public boolean isDefaultCatalog(String catalog, String user) {
        return catalog == null;
    }

    @Override
    public boolean isDefaultSchema(String schema, String user) {
        return user.equalsIgnoreCase(schema);
    }

    @Override
    public String renderCreateSequence(DBSequence sequence) {
        Boolean order;
        String result = super.renderCreateSequence(sequence);
        Long cache = sequence.getCache();
        if (cache != null) {
            result = result + " CACHE " + cache;
        }
        if ((order = sequence.isOrder()) != null) {
            result = result + (order != false ? " ORDER" : "NOORDER");
        }
        return result;
    }

    @Override
    protected String renderSequenceNameAndType(DBSequence sequence) {
        String schemaName = sequence.getSchemaName();
        return (schemaName != null ? "\"" + schemaName + "\"." : "") + '\"' + sequence.getName() + '\"';
    }

    @Override
    public String renderFetchSequenceValue(String sequenceName) {
        return "select " + sequenceName + ".nextval from dual";
    }

    @Override
    public String formatTimestamp(Timestamp value) {
        String renderedTimestamp = new TimestampFormatter(TIMESTAMP_PATTERN).format(value);
        return MessageFormat.format(TIMESTAMP_MESSAGE, renderedTimestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBSequence[] querySequences(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select sequence_name, min_value, max_value, increment_by, cycle_flag, order_flag, cache_size, last_number from user_sequences");
        try {
            ArrayBuilder builder = new ArrayBuilder(DBSequence.class);
            while (resultSet.next()) {
                DBSequence sequence = new DBSequence(resultSet.getString(1), null);
                sequence.setMinValue(new BigInteger(resultSet.getString(2)));
                sequence.setMaxValue(new BigInteger(resultSet.getString(3)));
                sequence.setIncrement(new BigInteger(resultSet.getString(4)));
                sequence.setCycle("Y".equals(resultSet.getString(5)));
                sequence.setOrder("Y".equals(resultSet.getString(6)));
                sequence.setCache(resultSet.getLong(7));
                sequence.setLastNumber(new BigInteger(resultSet.getString(8)));
                builder.add((Object)sequence);
                LOGGER.debug("Imported sequence {}", (Object)sequence.getName());
            }
            DBSequence[] dBSequenceArray = (DBSequence[])builder.toArray();
            return dBSequenceArray;
        }
        finally {
            DBUtil.closeResultSetAndStatement(resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBCheckConstraint[] queryCheckConstraints(Connection connection, String schemaName) throws SQLException {
        Statement statement = connection.createStatement();
        statement.setFetchSize(300);
        String query = "select owner, constraint_name, table_name, search_condition from user_constraints where constraint_type = 'C'";
        if (schemaName != null) {
            query = query + " and owner = '" + schemaName.toUpperCase() + "'";
        }
        ResultSet resultSet = statement.executeQuery(query);
        ArrayBuilder builder = new ArrayBuilder(DBCheckConstraint.class);
        try {
            while (resultSet.next()) {
                String ownerName = resultSet.getString("owner");
                if (schemaName != null && !StringUtil.equalsIgnoreCase((String)schemaName, (String)ownerName)) continue;
                String constraintName = resultSet.getString("constraint_name");
                String tableName = resultSet.getString("table_name");
                String condition = resultSet.getString("search_condition");
                if (!SIMPLE_NOT_NULL_CHECK.matcher(condition).matches()) {
                    try {
                        DBCheckConstraint constraint = new DBCheckConstraint(constraintName, !this.isDeterministicCheckName(constraintName), tableName, condition);
                        builder.add((Object)constraint);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error parsing check constraint ", (Throwable)e);
                    }
                }
                LOGGER.debug("Imported check for table {}: {}", (Object)tableName, (Object)condition);
            }
        }
        finally {
            DBUtil.closeResultSetAndStatement(resultSet);
        }
        return (DBCheckConstraint[])builder.toArray();
    }

    public boolean isDeterministicCheckName(String checkName) {
        return !this.randomNamePattern.matcher(checkName).matches();
    }

    @Override
    public boolean isDeterministicPKName(String pkName) {
        return !this.randomNamePattern.matcher(pkName).matches();
    }

    @Override
    public boolean isDeterministicUKName(String ukName) {
        return !this.randomNamePattern.matcher(ukName).matches();
    }

    @Override
    public boolean isDeterministicFKName(String fkName) {
        return !this.randomNamePattern.matcher(fkName).matches();
    }

    @Override
    public boolean isDeterministicIndexName(String indexName) {
        return !this.randomNamePattern.matcher(indexName).matches();
    }

    @Override
    public boolean supportsRegex() {
        return true;
    }

    @Override
    public String regexQuery(String expression, boolean not, String regex) {
        return (not ? "NOT " : "") + "REGEXP_LIKE(" + expression + ", '" + regex + "')";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DBTrigger> queryTriggers(DBSchema schema, Connection connection) throws SQLException {
        String query = "SELECT OWNER, TRIGGER_NAME, TRIGGER_TYPE, TRIGGERING_EVENT, TABLE_OWNER, BASE_OBJECT_TYPE, TABLE_NAME, COLUMN_NAME, REFERENCING_NAMES, WHEN_CLAUSE, STATUS, DESCRIPTION, ACTION_TYPE, TRIGGER_BODY FROM SYS.ALL_TRIGGERS";
        if (schema != null) {
            query = query + " WHERE OWNER = '" + schema.getName().toUpperCase() + "'";
        }
        ResultSet resultSet = DBUtil.executeQuery(query, connection);
        ArrayList<DBTrigger> triggers = new ArrayList<DBTrigger>();
        try {
            while (resultSet.next()) {
                DBTrigger trigger = new DBTrigger(resultSet.getString(2), null);
                trigger.setOwner(schema);
                schema.receiveTrigger(trigger);
                trigger.setTriggerType(resultSet.getString(3));
                trigger.setTriggeringEvent(resultSet.getString(4));
                trigger.setTableOwner(resultSet.getString(5));
                trigger.setBaseObjectType(resultSet.getString(6));
                trigger.setTableName(resultSet.getString(7));
                trigger.setColumnName(resultSet.getString(8));
                trigger.setReferencingNames(resultSet.getString(9));
                trigger.setWhenClause(resultSet.getString(10));
                trigger.setStatus(resultSet.getString(11));
                trigger.setDescription(resultSet.getString(12));
                trigger.setActionType(resultSet.getString(13));
                trigger.setTriggerBody(resultSet.getString(14));
                triggers.add(trigger);
                LOGGER.debug("Imported trigger: {}", (Object)trigger.getName());
            }
        }
        finally {
            DBUtil.closeResultSetAndStatement(resultSet);
        }
        return triggers;
    }

    @Override
    public List<DBPackage> queryPackages(DBSchema schema, Connection connection) throws SQLException {
        String query = "SELECT USER, OBJECT_NAME, SUBOBJECT_NAME, OBJECT_ID, OBJECT_TYPE, STATUS FROM USER_OBJECTS WHERE UPPER(OBJECT_TYPE) = 'PACKAGE'";
        List<Object[]> pkgInfos = DBUtil.query(query, connection);
        OrderedMap packages = new OrderedMap();
        for (int i = 0; i < pkgInfos.size(); ++i) {
            Object[] pkgInfo = pkgInfos.get(i);
            String ownerName = (String)pkgInfo[0];
            if (schema != null && !schema.getName().equals(ownerName)) continue;
            String name = (String)pkgInfo[1];
            DBPackage pkg = new DBPackage(name, null);
            schema.receivePackage(pkg);
            pkg.setSchema(schema);
            pkg.setSubObjectName((String)pkgInfo[2]);
            pkg.setObjectId(pkgInfo[3].toString());
            pkg.setObjectType((String)pkgInfo[4]);
            pkg.setStatus((String)pkgInfo[5]);
            packages.put((Object)pkg.getName(), (Object)pkg);
            LOGGER.debug("Imported package {}", (Object)pkg);
        }
        query = "SELECT OBJECT_NAME, PROCEDURE_NAME, OBJECT_ID, SUBPROGRAM_ID, OVERLOAD FROM SYS.USER_PROCEDURES WHERE UPPER(OBJECT_TYPE) = 'PACKAGE' AND PROCEDURE_NAME IS NOT NULL AND OBJECT_NAME IN (" + CollectionUtil.formatCommaSeparatedList((List)NameUtil.getNames((Collection)packages.values()), (Character)Character.valueOf('\'')) + ")";
        List<Object[]> procInfos = DBUtil.query(query, connection);
        for (int i = 0; i < procInfos.size(); ++i) {
            Object[] procInfo = procInfos.get(i);
            DBPackage owner = (DBPackage)packages.get((Object)((String)procInfo[0]));
            String name = (String)procInfo[1];
            DBProcedure proc = new DBProcedure(name, owner);
            proc.setObjectId(procInfo[2].toString());
            proc.setSubProgramId(procInfo[3].toString());
            proc.setOverload((String)procInfo[4]);
            LOGGER.debug("Imported package procedure {}.{}", (Object)owner.getName(), (Object)proc.getName());
        }
        return packages.values();
    }

    @Override
    public void restrictRownums(int firstRowIndex, int rowCount, Query query) {
        String condition = firstRowIndex > 1 ? "ROWNUM BETWEEN " + firstRowIndex + " AND " + (firstRowIndex + rowCount) : "ROWNUM <= " + rowCount;
        query.and(condition);
    }

    @Override
    public String trim(String expression) {
        return "TRIM(" + expression + ")";
    }
}

