/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.dialect;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.regex.Pattern;
import org.databene.commons.ArrayBuilder;
import org.databene.jdbacl.DBUtil;
import org.databene.jdbacl.DatabaseDialect;
import org.databene.jdbacl.model.DBSequence;
import org.databene.jdbacl.sql.Query;

public class HSQLDialect
extends DatabaseDialect {
    private static final String DATE_PATTERN = "''yyyy-MM-dd''";
    private static final String TIME_PATTERN = "''HH:mm:ss''";
    private static final String DATETIME_PATTERN = "''yyyy-MM-dd HH:mm:ss''";
    Pattern randomPKNamePattern = Pattern.compile("SYS_IDX_\\w+");
    Pattern randomUKNamePattern = Pattern.compile("SYS_IDX_SYS_\\w+");
    Pattern randomFKNamePattern = Pattern.compile("SYS_FK_\\w+");
    Pattern randomIndexNamePattern = Pattern.compile("SYS_IDX_\\w+");

    public HSQLDialect() {
        super("hsql", true, true, DATE_PATTERN, TIME_PATTERN, DATETIME_PATTERN);
    }

    public boolean isDefaultCatalog(String catalog, String user) {
        return catalog == null;
    }

    public boolean isDefaultSchema(String schema, String user) {
        return "PUBLIC".equalsIgnoreCase(schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBSequence[] querySequences(Connection connection) throws SQLException {
        String query = "select SEQUENCE_CATALOG, SEQUENCE_SCHEMA, SEQUENCE_NAME, START_WITH, INCREMENT, MINIMUM_VALUE, MAXIMUM_VALUE, CYCLE_OPTION from information_schema.system_sequences";
        ArrayBuilder builder = new ArrayBuilder(DBSequence.class);
        ResultSet resultSet = DBUtil.executeQuery(query, connection);
        try {
            while (resultSet.next()) {
                String name = resultSet.getString("SEQUENCE_NAME");
                DBSequence sequence = new DBSequence(name, resultSet.getString("SEQUENCE_CATALOG"), resultSet.getString("SEQUENCE_SCHEMA"));
                sequence.setStart(new BigInteger(resultSet.getString("START_WITH")));
                sequence.setIncrement(new BigInteger(resultSet.getString("INCREMENT")));
                sequence.setMinValue(new BigInteger(resultSet.getString("MINIMUM_VALUE")));
                sequence.setMaxValue(new BigInteger(resultSet.getString("MAXIMUM_VALUE")));
                sequence.setCycle(resultSet.getBoolean("CYCLE_OPTION"));
                builder.add((Object)sequence);
            }
        }
        finally {
            DBUtil.closeResultSetAndStatement(resultSet);
        }
        return (DBSequence[])builder.toArray();
    }

    public String renderFetchSequenceValue(String sequenceName) {
        return "call next value for " + sequenceName;
    }

    public void setNextSequenceValue(String sequenceName, long value, Connection connection) throws SQLException {
        DBUtil.executeUpdate(this.renderSequenceValue(sequenceName, value), connection);
    }

    public String renderSequenceValue(String sequenceName, long value) {
        return "alter sequence " + sequenceName + " restart with " + value;
    }

    public String renderDropSequence(String name) {
        return "drop sequence " + name;
    }

    public boolean isDeterministicPKName(String pkName) {
        return !this.randomPKNamePattern.matcher(pkName).matches();
    }

    public boolean isDeterministicUKName(String ukName) {
        return !this.randomUKNamePattern.matcher(ukName).matches();
    }

    public boolean isDeterministicFKName(String fkName) {
        return !this.randomFKNamePattern.matcher(fkName).matches();
    }

    public boolean isDeterministicIndexName(String indexName) {
        return !this.randomIndexNamePattern.matcher(indexName).matches();
    }

    public boolean supportsRegex() {
        return false;
    }

    public String trim(String expression) {
        return "LTRIM(RTRIM(" + expression + "))";
    }

    public void restrictRownums(int offset, int rowCount, Query query) {
        if (offset == 0) {
            query.addSelectCondition("TOP " + rowCount);
        } else {
            query.addSelectCondition("LIMIT " + offset + " " + rowCount);
        }
    }
}

