/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.dialect;

import java.sql.Connection;
import org.databene.commons.ConfigurationError;
import org.databene.commons.ConnectFailedException;
import org.databene.jdbacl.DBUtil;

public class H2Util {
    public static final String IN_MEMORY_URL_PREFIX = "jdbc:h2:mem:";
    public static final String DRIVER = "org.h2.Driver";
    public static final String DEFAULT_USER = "sa";
    public static final String DEFAULT_PASSWORD = "";
    public static final String DEFAULT_SCHEMA = "PUBLIC";
    public static final int DEFAULT_PORT = 9001;

    public static Connection connectInMemoryDB(String dbName, int port) throws ConnectFailedException {
        return H2Util.connectInMemoryDB(dbName + ":" + port);
    }

    public static Connection connectInMemoryDB(String dbName) throws ConnectFailedException {
        String driver = DRIVER;
        try {
            Class.forName(driver);
            String url = H2Util.getInMemoryURL(dbName);
            String user = DEFAULT_USER;
            String password = DEFAULT_PASSWORD;
            return DBUtil.connect(url, DRIVER, user, password, false);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationError("JDBC driver not found: " + driver, (Throwable)e);
        }
    }

    public static String getInMemoryURL(String dbName) {
        String url = IN_MEMORY_URL_PREFIX + dbName;
        return url;
    }
}

