/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.dialect;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.regex.Pattern;
import org.databene.commons.ArrayBuilder;
import org.databene.jdbacl.DBUtil;
import org.databene.jdbacl.DatabaseDialect;
import org.databene.jdbacl.model.DBSequence;
import org.databene.jdbacl.sql.Query;

public class H2Dialect
extends DatabaseDialect {
    private static final String DATE_PATTERN = "''yyyy-MM-dd''";
    private static final String TIME_PATTERN = "''HH:mm:ss''";
    private static final String DATETIME_PATTERN = "''yyyy-MM-dd HH:mm:ss''";
    Pattern randomPKNamePattern = Pattern.compile("CONSTRAINT_\\w+");
    Pattern randomUKNamePattern = Pattern.compile("CONSTRAINT_INDEX_\\w+");
    Pattern randomFKNamePattern = Pattern.compile("CONSTRAINT_\\w+");
    Pattern randomIndexNamePattern = Pattern.compile("CONSTRAINT_INDEX_\\w+|PRIMARY_KEY_\\w+");

    public H2Dialect() {
        super("h2", true, true, DATE_PATTERN, TIME_PATTERN, DATETIME_PATTERN);
    }

    public boolean isDefaultCatalog(String catalog, String user) {
        return catalog == null;
    }

    public boolean isDefaultSchema(String schema, String user) {
        return "PUBLIC".equalsIgnoreCase(schema);
    }

    public boolean isSequenceBoundarySupported() {
        return false;
    }

    public DBSequence[] querySequences(Connection connection) throws SQLException {
        String query = "select SEQUENCE_CATALOG, SEQUENCE_SCHEMA, SEQUENCE_NAME, CURRENT_VALUE, INCREMENT, CACHE from information_schema.sequences";
        ArrayBuilder builder = new ArrayBuilder(DBSequence.class);
        ResultSet resultSet = DBUtil.executeQuery(query, connection);
        while (resultSet.next()) {
            String name = resultSet.getString("SEQUENCE_NAME");
            DBSequence sequence = new DBSequence(name, null);
            sequence.setStart(new BigInteger(resultSet.getString("CURRENT_VALUE")));
            sequence.setLastNumber(sequence.getStart());
            sequence.setIncrement(new BigInteger(resultSet.getString("INCREMENT")));
            sequence.setCache(resultSet.getLong("CACHE"));
            builder.add((Object)sequence);
        }
        return (DBSequence[])builder.toArray();
    }

    public String renderFetchSequenceValue(String sequenceName) {
        return "select next value for " + sequenceName;
    }

    public void setNextSequenceValue(String sequenceName, long value, Connection connection) throws SQLException {
        DBUtil.executeUpdate(this.setSequenceValue(sequenceName, value), connection);
    }

    public String setSequenceValue(String sequenceName, long value) {
        return "alter sequence " + sequenceName + " restart with " + value;
    }

    public String renderDropSequence(String name) {
        return "drop sequence " + name;
    }

    public boolean isDeterministicPKName(String pkName) {
        return !this.randomPKNamePattern.matcher(pkName).matches();
    }

    public boolean isDeterministicUKName(String ukName) {
        return !this.randomUKNamePattern.matcher(ukName).matches();
    }

    public boolean isDeterministicFKName(String fkName) {
        return !this.randomFKNamePattern.matcher(fkName).matches();
    }

    public boolean isDeterministicIndexName(String indexName) {
        return !this.randomIndexNamePattern.matcher(indexName).matches();
    }

    public boolean supportsRegex() {
        return true;
    }

    public String regexQuery(String expression, boolean not, String regex) {
        return expression + (not ? " NOT" : "") + " REGEXP '" + regex + "'";
    }

    public void restrictRownums(int firstRowIndex, int rowCount, Query query) {
        throw new UnsupportedOperationException("H2Dialect.applyRownumRestriction() is not implemented");
    }
}

