/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.dialect;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.regex.Pattern;
import org.databene.commons.ArrayBuilder;
import org.databene.jdbacl.DBUtil;
import org.databene.jdbacl.DatabaseDialect;
import org.databene.jdbacl.model.DBSequence;
import org.databene.jdbacl.sql.Query;

public class FirebirdDialect
extends DatabaseDialect {
    private static final String DATE_PATTERN = "''yyyy-MM-dd''";
    private static final String TIME_PATTERN = "''HH:mm:ss''";
    private static final String DATETIME_PATTERN = "''yyyy-MM-dd HH:mm:ss''";
    Pattern randomPKNamePattern = Pattern.compile("INTEG_\\d+");
    Pattern randomUKNamePattern = Pattern.compile("RDB\\$\\w+");
    Pattern randomFKNamePattern = Pattern.compile("INTEG_\\d+");
    Pattern randomIndexNamePattern = Pattern.compile("RDB\\$\\w+");

    public FirebirdDialect() {
        super("firebird", true, true, DATE_PATTERN, TIME_PATTERN, DATETIME_PATTERN);
    }

    public String getJDBCDriverClass() {
        return "org.firebirdsql.jdbc.FBDriver";
    }

    public boolean isDefaultCatalog(String catalog, String user) {
        return true;
    }

    public boolean isDefaultSchema(String schema, String user) {
        return true;
    }

    public boolean isSequenceBoundarySupported() {
        return false;
    }

    public void createSequence(String name, long initialValue, Connection connection) throws SQLException {
        DBUtil.executeUpdate(this.renderCreateSequence(name), connection);
        DBUtil.executeUpdate(this.renderSetSequenceValue(name, initialValue), connection);
    }

    public String renderCreateSequence(DBSequence sequence) {
        String result = this.renderCreateSequence(sequence.getName());
        BigInteger start = sequence.getStart();
        if (start != null && FirebirdDialect.isNotOne(start)) {
            result = result + "; " + this.renderSetSequenceValue(sequence.getName(), start.longValue()) + ";";
        }
        return result;
    }

    public String renderCreateSequence(String name) {
        return "CREATE GENERATOR " + name;
    }

    public String renderDropSequence(String sequenceName) {
        return "drop generator " + sequenceName;
    }

    public String renderFetchSequenceValue(String sequenceName) {
        return "select gen_id(" + sequenceName + ", 1) from RDB$DATABASE;";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBSequence[] querySequences(Connection connection) throws SQLException {
        String query = "select RDB$GENERATOR_NAME, RDB$GENERATOR_ID, RDB$SYSTEM_FLAG, RDB$DESCRIPTION from RDB$GENERATORS where RDB$GENERATOR_NAME NOT LIKE '%$%'";
        ResultSet resultSet = null;
        try {
            resultSet = DBUtil.executeQuery(query, connection);
            ArrayBuilder builder = new ArrayBuilder(DBSequence.class);
            while (resultSet.next()) {
                builder.add((Object)new DBSequence(resultSet.getString(1).trim(), null));
            }
            DBSequence[] dBSequenceArray = (DBSequence[])builder.toArray();
            return dBSequenceArray;
        }
        finally {
            DBUtil.closeResultSetAndStatement(resultSet);
        }
    }

    public void setNextSequenceValue(String sequenceName, long value, Connection connection) throws SQLException {
        DBUtil.executeUpdate(this.renderSetSequenceValue(sequenceName, value), connection);
    }

    public String renderSetSequenceValue(String sequenceName, long value) {
        return "SET GENERATOR " + sequenceName + " TO " + (value - 1L);
    }

    public boolean isDeterministicPKName(String pkName) {
        return !this.randomPKNamePattern.matcher(pkName).matches();
    }

    public boolean isDeterministicUKName(String ukName) {
        return !this.randomUKNamePattern.matcher(ukName).matches();
    }

    public boolean isDeterministicFKName(String fkName) {
        return !this.randomFKNamePattern.matcher(fkName).matches();
    }

    public boolean isDeterministicIndexName(String indexName) {
        return !this.randomIndexNamePattern.matcher(indexName).matches();
    }

    public void restrictRownums(int firstRowIndex, int rowCount, Query query) {
        throw new UnsupportedOperationException("FirebirdDialect.applyRownumRestriction() is not implemented");
    }
}

