/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.dialect;

import java.util.regex.Pattern;
import org.databene.jdbacl.DatabaseDialect;
import org.databene.jdbacl.sql.Query;

public class DerbyDialect
extends DatabaseDialect {
    private static final String DATE_PATTERN = "'DATE('''yyyy-MM-dd''')'";
    private static final String TIME_PATTERN = "'TIME('''HH:mm:ss''')'";
    private static final String DATETIME_PATTERN = "'TIMESTAMP('''yyyy-MM-dd HH:mm:ss''')'";
    Pattern randomPKNamePattern = Pattern.compile("SQL[0-9A-F]{15}");
    Pattern randomUKNamePattern = Pattern.compile("SQL[0-9A-F]{15}");
    Pattern randomFKNamePattern = Pattern.compile("FK[0-9A-F]{15,16}");
    Pattern randomIndexNamePattern = Pattern.compile("SQL\\d+");

    public DerbyDialect() {
        this(false);
    }

    public DerbyDialect(boolean sequenceSupported) {
        super("derby", true, sequenceSupported, DATE_PATTERN, TIME_PATTERN, DATETIME_PATTERN);
    }

    public boolean isDefaultCatalog(String catalog, String user) {
        return true;
    }

    public boolean isDefaultSchema(String schema, String user) {
        return (schema = schema.toUpperCase()).equalsIgnoreCase("APP") || schema.equalsIgnoreCase(user);
    }

    public boolean isDeterministicPKName(String pkName) {
        return !this.randomPKNamePattern.matcher(pkName).matches();
    }

    public boolean isDeterministicUKName(String ukName) {
        return !this.randomUKNamePattern.matcher(ukName).matches();
    }

    public boolean isDeterministicFKName(String fkName) {
        return !this.randomFKNamePattern.matcher(fkName).matches();
    }

    public boolean isDeterministicIndexName(String indexName) {
        return !this.randomIndexNamePattern.matcher(indexName).matches();
    }

    public void restrictRownums(int firstRowIndex, int rowCount, Query query) {
        throw new UnsupportedOperationException("DerbyDialect.applyRownumRestriction() is not implemented");
    }
}

