/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.dialect;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.databene.commons.ArrayBuilder;
import org.databene.jdbacl.DBUtil;
import org.databene.jdbacl.dialect.DerbyDialect;
import org.databene.jdbacl.model.DBSequence;

public class Derby10_6Dialect
extends DerbyDialect {
    public Derby10_6Dialect() {
        super(true);
    }

    public String renderCreateSequence(DBSequence sequence) {
        return super.renderCreateSequence(sequence);
    }

    protected String renderSequenceNameAndType(DBSequence sequence) {
        String schemaName = sequence.getSchemaName();
        return (schemaName != null ? schemaName + '.' : "") + sequence.getName() + " AS BIGINT";
    }

    protected String sequenceNoCycle() {
        return "NO CYCLE";
    }

    public String renderDropSequence(String sequenceName) {
        return "DROP SEQUENCE " + sequenceName + " RESTRICT";
    }

    public DBSequence[] querySequences(Connection connection) throws SQLException {
        List<Object[]> rows = DBUtil.query("SELECT SEQUENCENAME, STARTVALUE, INCREMENT, MAXIMUMVALUE, MINIMUMVALUE, CYCLEOPTION, CURRENTVALUE FROM SYS.SYSSEQUENCES", connection);
        ArrayBuilder builder = new ArrayBuilder(DBSequence.class, rows.size());
        for (Object[] row : rows) {
            DBSequence sequence = new DBSequence(row[0].toString(), null);
            sequence.setStart(new BigInteger(row[1].toString()));
            sequence.setIncrement(new BigInteger(row[2].toString()));
            sequence.setMaxValue(new BigInteger(row[3].toString()));
            sequence.setMinValue(new BigInteger(row[4].toString()));
            sequence.setCycle("Y".equals(row[5].toString()));
            sequence.setLastNumber(new BigInteger(row[6].toString()));
            builder.add((Object)sequence);
        }
        return (DBSequence[])builder.toArray();
    }

    public String renderFetchSequenceValue(String sequenceName) {
        return "VALUES (NEXT VALUE FOR " + sequenceName + ")";
    }

    public void setNextSequenceValue(String sequenceName, long nextValue, Connection connection) throws SQLException {
        DBSequence sequence = this.getSequence(sequenceName, connection);
        BigInteger lastNumber = sequence.getLastNumber();
        long defaultNext = lastNumber.add(BigInteger.ONE).longValue();
        if (nextValue != defaultNext) {
            DBUtil.executeUpdate(this.renderDropSequence(sequenceName), connection);
            sequence.setStart(BigInteger.valueOf(nextValue));
            DBUtil.executeUpdate(this.renderCreateSequence(sequence), connection);
        }
    }
}

