/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.dialect;

import java.util.regex.Pattern;
import org.databene.jdbacl.DatabaseDialect;
import org.databene.jdbacl.sql.Query;

public class DB2Dialect
extends DatabaseDialect {
    private static final String DATE_PATTERN = "''yyyy-MM-dd''";
    private static final String TIME_PATTERN = "''HH:mm:ss''";
    private static final String DATETIME_PATTERN = "''yyyy-MM-dd HH:mm:ss''";
    Pattern randomNamePattern = Pattern.compile("SQL\\d{15}");

    public DB2Dialect() {
        super("db2", false, true, DATE_PATTERN, TIME_PATTERN, DATETIME_PATTERN);
    }

    public boolean isDefaultCatalog(String catalog, String user) {
        return true;
    }

    public boolean isDefaultSchema(String schema, String user) {
        return true;
    }

    public String renderFetchSequenceValue(String sequenceName) {
        String table = "sysibm.sysdummy1";
        String sequence = sequenceName;
        int sep = sequenceName.lastIndexOf(46);
        if (sep > 0) {
            table = sequenceName.substring(0, sep);
            sequence = sequenceName.substring(sep + 1);
        }
        return "select nextval for " + sequence + " from " + table;
    }

    public boolean isDeterministicPKName(String pkName) {
        return !this.randomNamePattern.matcher(pkName).matches();
    }

    public boolean isDeterministicUKName(String ukName) {
        return !this.randomNamePattern.matcher(ukName).matches();
    }

    public boolean isDeterministicFKName(String fkName) {
        return !this.randomNamePattern.matcher(fkName).matches();
    }

    public boolean isDeterministicIndexName(String indexName) {
        return !this.randomNamePattern.matcher(indexName).matches();
    }

    public void restrictRownums(int firstRowIndex, int rowCount, Query query) {
        throw new UnsupportedOperationException("DB2Dialect.applyRownumRestriction() is not implemented");
    }
}

