/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl;

import java.io.Closeable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.databene.commons.IOUtil;
import org.databene.commons.StringUtil;
import org.databene.jdbacl.DBUtil;
import org.databene.jdbacl.ResultSetIterator;
import org.databene.webdecs.DataContainer;
import org.databene.webdecs.DataIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetDataIterator
implements DataIterator<ResultSet> {
    private ResultSet resultSet;
    private String[] columnLabels;
    private String query;
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultSetIterator.class);

    public ResultSetDataIterator(ResultSet resultSet) {
        this(resultSet, "");
    }

    public ResultSetDataIterator(ResultSet resultSet, String query) {
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet is null");
        }
        this.resultSet = resultSet;
        if (StringUtil.isEmpty((CharSequence)query)) {
            throw new IllegalArgumentException("query is empty");
        }
        this.query = query;
    }

    public String[] getColumnLabels() {
        if (this.columnLabels == null) {
            try {
                ResultSetMetaData metaData = this.resultSet.getMetaData();
                int n = metaData.getColumnCount();
                this.columnLabels = new String[n];
                for (int i = 0; i < n; ++i) {
                    this.columnLabels[i] = metaData.getColumnLabel(i + 1);
                }
            }
            catch (SQLException e) {
                throw new RuntimeException("Error querying column meta data", e);
            }
        }
        return this.columnLabels;
    }

    public Class<ResultSet> getType() {
        return ResultSet.class;
    }

    public DataContainer<ResultSet> next(DataContainer<ResultSet> container) {
        LOGGER.debug("next() called on {}", (Object)this);
        if (this.resultSet == null) {
            return null;
        }
        try {
            if (this.resultSet.next()) {
                return container.setData((Object)this.resultSet);
            }
            IOUtil.close((Closeable)((Object)this));
            return null;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void close() {
        LOGGER.debug("closing {}", (Object)this);
        if (this.resultSet == null) {
            return;
        }
        DBUtil.closeResultSetAndStatement(this.resultSet);
        this.resultSet = null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.query + ']';
    }
}

