/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl;

import org.databene.commons.ConnectFailedException;
import org.databene.commons.ImportFailedException;
import org.databene.commons.TreeModel;
import org.databene.commons.tree.TreeLogger;
import org.databene.commons.ui.ConsoleInfoPrinter;
import org.databene.commons.version.VersionInfo;
import org.databene.jdbacl.DatabaseTreeModel;
import org.databene.jdbacl.model.Database;
import org.databene.jdbacl.model.jdbc.JDBCMetaDataUtil;

public class Main {
    public static void main(String[] args) throws ConnectFailedException, ImportFailedException {
        String environment = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-h".equals(arg)) {
                Main.printHelpAndExit(0);
                continue;
            }
            environment = arg;
        }
        if (environment == null) {
            Main.printErrorAndHelpAndExit("No environment specified", -1);
        }
        Database database = JDBCMetaDataUtil.getMetaData(environment, true, true, true, true, ".*", null, false, true);
        new TreeLogger().log((TreeModel)new DatabaseTreeModel(database));
    }

    private static void printErrorAndHelpAndExit(String message, int status) {
        ConsoleInfoPrinter.printHelp((String[])new String[]{"Error: " + message});
        Main.printHelp();
        System.exit(status);
    }

    private static void printHelpAndExit(int status) {
        Main.printHelp();
        System.exit(status);
    }

    private static void printHelp() {
        VersionInfo version = VersionInfo.getInfo((String)"jdbacl");
        ConsoleInfoPrinter.printHelp((String[])new String[]{"jdbacl " + version});
        ConsoleInfoPrinter.printHelp((String[])new String[]{"Usage: java -jar jdbacle-" + version.getVersion() + ".jar [options] <environment>"});
        ConsoleInfoPrinter.printHelp((String[])new String[]{"", "Options:", "-h,--help               print this help", "", "The environment, eg. 'mydb', refers to a properties file, e.g. 'mydb.env.properties',", "which must provide JDBC connection data in the following format:", "\tdb_url=jdbc:hsqldb:hsql://localhost/mydb", "\tdb_driver=org.hsqldb.jdbcDriver", "\tdb_user=customer", "\tdb_password=secret"});
    }
}

