/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl;

import java.io.IOException;
import java.util.Map;
import org.databene.commons.BeanUtil;
import org.databene.commons.DeploymentError;
import org.databene.commons.IOUtil;
import org.databene.commons.version.VersionNumber;
import org.databene.jdbacl.DatabaseDialect;
import org.databene.jdbacl.dialect.UnknownDialect;

public class DatabaseDialectManager {
    private static final String FILENAME = "org/databene/jdbacl/databene.db_dialect.properties";
    private static Map<String, String> mappings;

    public static DatabaseDialect getDialectForProduct(String productName, VersionNumber version) {
        String normalizedProductName = productName.toLowerCase().replace(' ', '_');
        for (Map.Entry<String, String> entry : mappings.entrySet()) {
            String[] tokens = entry.getKey().split(" ");
            String p = tokens[0];
            String v = null;
            if (tokens.length == 2) {
                v = tokens[1];
            }
            if (!normalizedProductName.contains(p) || v != null && version != null && version.compareTo(VersionNumber.valueOf((String)v)) < 0) continue;
            return (DatabaseDialect)BeanUtil.newInstance((String)entry.getValue());
        }
        return new UnknownDialect(productName);
    }

    static {
        try {
            mappings = IOUtil.readProperties((String)FILENAME);
        }
        catch (IOException e) {
            throw new DeploymentError("Configuration file not found: org/databene/jdbacl/databene.db_dialect.properties");
        }
    }
}

