/*
 * Decompiled with CFR 0.152.
 */
package org.databene.webdecs.xml;

import java.util.ArrayList;
import java.util.List;
import org.databene.commons.ArrayUtil;
import org.databene.commons.ParseException;
import org.databene.commons.xml.XMLUtil;
import org.databene.webdecs.xml.XMLElementParser;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLElementParserFactory<E> {
    protected List<XMLElementParser<E>> parsers = new ArrayList<XMLElementParser<E>>();

    public void addParser(XMLElementParser<E> parser) {
        this.parsers.add(parser);
    }

    public XMLElementParser<E> getParser(Element element, E[] parentPath) {
        for (int i = this.parsers.size() - 1; i >= 0; --i) {
            XMLElementParser<E> parser = this.parsers.get(i);
            if (!parser.supports(element, parentPath)) continue;
            return parser;
        }
        Object parent = ArrayUtil.isEmpty(parentPath) ? null : ArrayUtil.lastElementOf((Object[])parentPath);
        String message = "Syntax Error: Element '" + element.getNodeName() + "' not supported " + (parent != null ? "in the context of a " + parent.getClass().getSimpleName() : "as top level element");
        throw new ParseException(message, XMLUtil.format((Element)element));
    }
}

