/*
 * Decompiled with CFR 0.152.
 */
package org.databene.webdecs.xml;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.databene.commons.ArrayFormat;
import org.databene.commons.ArrayUtil;
import org.databene.commons.CollectionUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.StringUtil;
import org.databene.commons.SyntaxError;
import org.databene.commons.xml.XMLUtil;
import org.databene.webdecs.xml.ParseContext;
import org.databene.webdecs.xml.XMLElementParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXMLElementParser<E>
implements XMLElementParser<E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractXMLElementParser.class);
    protected final String elementName;
    protected final Set<Class<?>> supportedParentTypes;
    protected Set<String> requiredAttributes;
    protected Set<String> optionalAttributes;

    public AbstractXMLElementParser(String elementName, Set<String> requiredAttributes, Set<String> optionalAttributes, Class<?> ... supportedParentTypes) {
        this.elementName = elementName;
        this.requiredAttributes = requiredAttributes != null ? requiredAttributes : Collections.emptySet();
        this.optionalAttributes = optionalAttributes != null ? optionalAttributes : Collections.emptySet();
        this.supportedParentTypes = CollectionUtil.toSet((Object[])supportedParentTypes);
    }

    @Override
    public boolean supports(Element element, E[] parentPath) {
        if (!this.elementName.equals(element.getNodeName())) {
            return false;
        }
        return CollectionUtil.isEmpty(this.supportedParentTypes) || parentPath == null || this.supportedParentTypes.contains(ArrayUtil.lastElementOf((Object[])parentPath).getClass());
    }

    @Override
    public final E parse(Element element, E[] parentPath, ParseContext<E> context) {
        this.checkAttributeSupport(element);
        return this.doParse(element, parentPath, context);
    }

    protected abstract E doParse(Element var1, E[] var2, ParseContext<E> var3);

    protected void checkAttributeSupport(Element element) {
        for (String attribute : XMLUtil.getAttributes((Element)element).keySet()) {
            if (this.requiredAttributes.contains(attribute) || this.optionalAttributes.contains(attribute)) continue;
            AbstractXMLElementParser.syntaxError("attribute '" + attribute + "' is not supported", element);
        }
        for (String requiredAttribute : this.requiredAttributes) {
            if (!StringUtil.isEmpty((CharSequence)element.getAttribute(requiredAttribute))) continue;
            AbstractXMLElementParser.syntaxError("Required attribute '" + requiredAttribute + "' is missing", element);
        }
    }

    protected static void checkSupportedAttributes(Element element, String ... supportedAttributes) {
        for (String actualAttribute : XMLUtil.getAttributes((Element)element).keySet()) {
            if (ArrayUtil.contains((Object)actualAttribute, (Object)supportedAttributes)) continue;
            AbstractXMLElementParser.syntaxError("attribute '" + actualAttribute + "' is not supported", element);
        }
    }

    protected static void assertElementName(String expectedName, Element element) {
        if (!element.getNodeName().equals(expectedName)) {
            throw new RuntimeException("Expected element name '" + expectedName + "', " + "found: '" + element.getNodeName());
        }
    }

    protected void excludeAttributes(Element element, String ... attributeNames) {
        String usedAttribute = null;
        for (String attributeName : attributeNames) {
            if (StringUtil.isEmpty((CharSequence)element.getAttribute(attributeName))) continue;
            if (usedAttribute == null) {
                usedAttribute = attributeName;
                continue;
            }
            AbstractXMLElementParser.syntaxError("The attributes '" + usedAttribute + "' and '" + attributeName + "' " + "exclude each other", element);
        }
    }

    protected void assertAtLeastOneAttributeIsSet(Element element, String ... attributeNames) {
        boolean ok = false;
        for (String attributeName : attributeNames) {
            if (StringUtil.isEmpty((CharSequence)element.getAttribute(attributeName))) continue;
            ok = true;
        }
        if (!ok) {
            AbstractXMLElementParser.syntaxError("At least one of these attributes must be set: " + ArrayFormat.format((Object[])attributeNames), element);
        }
    }

    protected void assertAttributeIsSet(Element element, String attributeName) {
        if (StringUtil.isEmpty((CharSequence)element.getAttribute(attributeName))) {
            AbstractXMLElementParser.syntaxError("Attribute '" + attributeName + "' is missing", element);
        }
    }

    protected void assertAttributeIsNotSet(Element element, String attributeName) {
        if (!StringUtil.isEmpty((CharSequence)element.getAttribute(attributeName))) {
            AbstractXMLElementParser.syntaxError("Attributes '" + attributeName + "' must not be set", element);
        }
    }

    protected Object parent(E[] parentPath) {
        if (ArrayUtil.isEmpty(parentPath)) {
            return null;
        }
        return ArrayUtil.lastElementOf((Object[])parentPath);
    }

    protected static String parseRequiredName(Element element) {
        String name = AbstractXMLElementParser.parseOptionalName(element);
        if (StringUtil.isEmpty((CharSequence)name)) {
            AbstractXMLElementParser.syntaxError("'name' attribute is missing", element);
        }
        return name;
    }

    protected static String parseOptionalName(Element element) {
        return AbstractXMLElementParser.getOptionalAttribute("name", element);
    }

    protected static Integer parseOptionalInteger(String attributeName, Element element) {
        String spec = AbstractXMLElementParser.getOptionalAttribute(attributeName, element);
        return spec != null ? Integer.valueOf(Integer.parseInt(spec)) : null;
    }

    protected static Boolean parseOptionalBoolean(String attributeName, Element element) {
        String spec = AbstractXMLElementParser.getOptionalAttribute(attributeName, element);
        return spec != null ? Boolean.valueOf(Boolean.parseBoolean(spec)) : null;
    }

    protected static Long parseOptionalLong(String attributeName, Element element) {
        String spec = AbstractXMLElementParser.getOptionalAttribute(attributeName, element);
        return spec != null ? Long.valueOf(Long.parseLong(spec)) : null;
    }

    public static String getRequiredAttribute(String name, Element element) {
        String value = AbstractXMLElementParser.getOptionalAttribute(name, element);
        if (value == null) {
            AbstractXMLElementParser.syntaxError("'" + name + "' attribute expected", element);
        }
        return value;
    }

    protected static String getOptionalAttribute(String name, Element element) {
        return StringUtil.emptyToNull((String)element.getAttribute(name));
    }

    protected static void checkAttributes(Element element, Set<String> supportedAttributes) {
        for (Map.Entry attribute : XMLUtil.getAttributes((Element)element).entrySet()) {
            if (supportedAttributes.contains(attribute.getKey())) continue;
            throw new ConfigurationError("Not a supported import attribute: " + (String)attribute.getKey());
        }
    }

    protected static void syntaxError(String message, Element element) {
        throw new SyntaxError("Syntax error: " + message, XMLUtil.format((Element)element));
    }

    protected static void syntaxWarning(String message, Element element) {
        LOGGER.warn("Syntax warning: " + message + " in " + XMLUtil.format((Element)element));
    }
}

