/*
 * Decompiled with CFR 0.152.
 */
package org.databene.webdecs.util;

import java.io.Closeable;
import org.databene.commons.Converter;
import org.databene.commons.IOUtil;
import org.databene.webdecs.DataIterator;
import org.databene.webdecs.DataSource;
import org.databene.webdecs.util.ConvertingDataIterator;
import org.databene.webdecs.util.DataSourceAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertingDataSource<S, T>
extends DataSourceAdapter<S, T> {
    protected Converter<S, T> converter;

    public ConvertingDataSource(DataSource<S> source, Converter<S, T> converter) {
        super(source, converter.getTargetType());
        this.converter = converter;
    }

    @Override
    public Class<T> getType() {
        return this.converter.getTargetType();
    }

    @Override
    public DataIterator<T> iterator() {
        return new ConvertingDataIterator(this.source.iterator(), this.converter);
    }

    @Override
    public void close() {
        if (this.converter instanceof Closeable) {
            IOUtil.close((Closeable)((Closeable)this.converter));
        }
        super.close();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.source + " -> " + this.converter + ']';
    }
}

