/*
 * Decompiled with CFR 0.152.
 */
package org.databene.webdecs.util;

import java.io.Closeable;
import org.databene.commons.Converter;
import org.databene.commons.IOUtil;
import org.databene.webdecs.DataContainer;
import org.databene.webdecs.DataIterator;
import org.databene.webdecs.util.DataIteratorAdapter;
import org.databene.webdecs.util.ThreadLocalDataContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertingDataIterator<S, T>
extends DataIteratorAdapter<S, T> {
    protected Converter<S, T> converter;
    protected ThreadLocalDataContainer<S> sourceContainer = new ThreadLocalDataContainer();

    public ConvertingDataIterator(DataIterator<S> source, Converter<S, T> converter) {
        super(source);
        this.converter = converter;
    }

    @Override
    public Class<T> getType() {
        return this.converter.getTargetType();
    }

    @Override
    public DataContainer<T> next(DataContainer<T> container) {
        DataContainer sourceValue = this.source.next((DataContainer)this.sourceContainer.get());
        if (sourceValue == null) {
            return null;
        }
        return container.setData(this.converter.convert(sourceValue.getData()));
    }

    @Override
    public void close() {
        if (this.converter instanceof Closeable) {
            IOUtil.close((Closeable)((Closeable)this.converter));
        }
        super.close();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[source:" + this.source + ", converter:" + this.converter + "]";
    }
}

