/*
 * Decompiled with CFR 0.152.
 */
package org.databene.webdecs.demo;

import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import org.databene.commons.Filter;
import org.databene.commons.ReaderLineIterator;
import org.databene.commons.iterator.FilteringIterator;

public class TextFilterDemo {
    private static final String FILE_NAME = "test.dat";

    public static void main(String[] args) throws IOException {
        FileReader reader = new FileReader(FILE_NAME);
        ReaderLineIterator src = new ReaderLineIterator((Reader)reader);
        LineFilter filter = new LineFilter();
        FilteringIterator iterator = new FilteringIterator((Iterator)src, (Filter)filter);
        BufferedWriter out = new BufferedWriter(new FileWriter("matches.csv"));
        int matchCount = 0;
        System.out.println("Running...");
        long startMillis = System.currentTimeMillis();
        while (iterator.hasNext()) {
            String row = (String)iterator.next();
            out.write(row);
            ++matchCount;
        }
        ((Writer)out).close();
        ((Reader)reader).close();
        long elapsedTime = System.currentTimeMillis() - startMillis;
        System.out.println("Processed file test.dat with " + src.lineCount() + " entries " + "within " + elapsedTime + "ms (" + (long)src.lineCount() * 1000L / elapsedTime + " entries per second)");
        System.out.println("Found " + matchCount + " matches");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LineFilter
    implements Filter<String> {
        LineFilter() {
        }

        public boolean accept(String candidate) {
            return candidate.contains("|3023293310905|");
        }
    }
}

