/*
 * Decompiled with CFR 0.152.
 */
package org.databene.webdecs.demo;

import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.databene.commons.Filter;
import org.databene.document.csv.ArrayCSVWriter;
import org.databene.document.csv.CSVLineIterator;
import org.databene.webdecs.DataContainer;
import org.databene.webdecs.util.FilteringDataIterator;

public class CSVFilterDemo {
    private static final String FILE_NAME = "test.dat";

    public static void main(String[] args) throws IOException {
        FileReader reader = new FileReader(FILE_NAME);
        CSVLineIterator src = new CSVLineIterator(reader, '|');
        RowFilter filter = new RowFilter();
        FilteringDataIterator<String[]> iterator = new FilteringDataIterator<String[]>(src, filter);
        BufferedWriter out = new BufferedWriter(new FileWriter("matches.csv"));
        ArrayCSVWriter csvWriter = new ArrayCSVWriter(out, '|');
        int matchCount = 0;
        System.out.println("Running...");
        long startMillis = System.currentTimeMillis();
        DataContainer<Object> cells = new DataContainer();
        while ((cells = iterator.next(cells)) != null) {
            csvWriter.writeElement(cells.getData());
            ++matchCount;
        }
        ((Writer)out).close();
        ((Reader)reader).close();
        long elapsedTime = System.currentTimeMillis() - startMillis;
        System.out.println("Processed file test.dat with " + src.lineCount() + " entries " + "within " + elapsedTime + "ms (" + (long)src.lineCount() * 1000L / elapsedTime + " entries per second)");
        System.out.println("Found " + matchCount + " matches");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class RowFilter
    implements Filter<String[]> {
        RowFilter() {
        }

        public boolean accept(String[] candidate) {
            return candidate.length > 2 && "3023293310905".equals(candidate[1]);
        }
    }
}

