/*
 * Decompiled with CFR 0.152.
 */
package org.databene.text;

import org.databene.commons.StringUtil;

public class LFNormalizingStringBuilder {
    private final StringBuilder builder;
    private final String lineSeparator;

    public LFNormalizingStringBuilder(String lineSeparator) {
        this.lineSeparator = lineSeparator;
        this.builder = new StringBuilder();
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public LFNormalizingStringBuilder append(String text) {
        this.builder.append(StringUtil.normalizeLineSeparators((String)text, (String)this.lineSeparator));
        return this;
    }

    public LFNormalizingStringBuilder append(char c) {
        if (c != '\r' && c != '\n') {
            this.builder.append(c);
        } else {
            this.builder.append(this.lineSeparator);
        }
        return this;
    }

    public String toString() {
        return this.builder.toString();
    }
}

