/*
 * Decompiled with CFR 0.152.
 */
package org.databene.text;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import org.databene.commons.ParseUtil;
import org.databene.commons.StringUtil;

public class AbbreviatedNumberFormat
extends NumberFormat {
    private static final long serialVersionUID = -3938256314974549704L;
    private Object[][] availableScales = new Object[][]{{"Mrd", new Double(1.0E9)}, {"Mrd.", new Double(1.0E9)}, {"Mio", new Double(1000000.0)}, {"Mio.", new Double(1000000.0)}, {"Tsd", new Double(1000.0)}, {"Tsd.", new Double(1000.0)}, {"T", new Double(1000.0)}};
    private String defaultScaleId;
    private double defaultScale;
    private NumberFormat snf;

    public AbbreviatedNumberFormat() {
        this(1.0);
    }

    public AbbreviatedNumberFormat(double scale) {
        this(scale, Locale.getDefault());
    }

    public AbbreviatedNumberFormat(Locale locale) {
        this(1.0, locale);
    }

    public AbbreviatedNumberFormat(double scale, Locale locale) {
        this.defaultScale = scale;
        this.defaultScaleId = "";
        for (int i = 0; i < this.availableScales.length; ++i) {
            if ((Double)this.availableScales[i][1] != scale) continue;
            this.defaultScaleId = (String)this.availableScales[i][0];
            break;
        }
        this.snf = NumberFormat.getInstance(locale);
        this.snf.setMinimumFractionDigits(2);
        this.snf.setMaximumFractionDigits(2);
        this.snf.setGroupingUsed(true);
    }

    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        if (!StringUtil.isEmpty((CharSequence)this.defaultScaleId)) {
            return this.formatFixed(number, toAppendTo, pos);
        }
        return this.formatFree(number, toAppendTo, pos);
    }

    public StringBuffer formatFixed(double number, StringBuffer toAppendTo, FieldPosition pos) {
        this.snf.format(number / this.defaultScale, toAppendTo, pos);
        if (!StringUtil.isEmpty((CharSequence)this.defaultScaleId)) {
            toAppendTo.append(' ');
            toAppendTo.append(this.defaultScaleId);
        }
        return toAppendTo;
    }

    private StringBuffer formatFree(double number, StringBuffer toAppendTo, FieldPosition pos) {
        String selectedPrefix = "";
        for (int i = 0; i < this.availableScales.length; ++i) {
            double scale = (Double)this.availableScales[i][1];
            if (!(number >= scale)) continue;
            selectedPrefix = (String)this.availableScales[i][0];
            this.snf.format(number /= scale, toAppendTo, pos);
            toAppendTo.append(' ');
            toAppendTo.append(selectedPrefix);
            return toAppendTo;
        }
        return this.snf.format(number, toAppendTo, pos);
    }

    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format((double)number, toAppendTo, pos);
    }

    public Number parse(String source, ParsePosition pos) {
        Number value = this.snf.parse(StringUtil.trim((String)source), pos);
        int start = ParseUtil.nextNonWhitespaceIndex((String)source, (int)pos.getIndex());
        if (start == -1) {
            return value;
        }
        for (int i = 0; i < this.availableScales.length; ++i) {
            String prefix = (String)this.availableScales[i][0];
            if (!source.substring(start).startsWith(prefix)) continue;
            value = new Double(value.doubleValue() * (Double)this.availableScales[i][1]);
            pos.setIndex(start + prefix.length());
            break;
        }
        return value;
    }
}

