/*
 * Decompiled with CFR 0.152.
 */
package org.databene.script.freemarker;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.databene.commons.Context;
import org.databene.script.AbstractScript;
import org.databene.script.ScriptException;

public class FreeMarkerScript
extends AbstractScript {
    private static Configuration cfg = new Configuration();
    private Template template;

    public FreeMarkerScript(String filename) throws IOException {
        this(cfg.getTemplate(filename));
    }

    public FreeMarkerScript(Template template) {
        this.template = template;
    }

    public static FreeMarkerScript createFromText(String text) {
        try {
            StringReader reader = new StringReader(text);
            Template template = new Template(text, (Reader)reader, cfg, null);
            return new FreeMarkerScript(template);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void execute(Context context, Writer out) throws IOException, ScriptException {
        try {
            this.template.process((Object)context, out);
        }
        catch (TemplateException e) {
            throw new ScriptException(e);
        }
    }

    public String toString() {
        return this.template.toString();
    }

    public int hashCode() {
        return this.template.hashCode();
    }

    public boolean equals(Object obj) {
        return this.template.equals(obj);
    }

    static {
        cfg.setClassForTemplateLoading(FreeMarkerScript.class, "/");
        cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        cfg.setNumberFormat("0.##");
    }
}

