/*
 * Decompiled with CFR 0.152.
 */
package org.databene.script;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.databene.commons.BeanUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Context;
import org.databene.commons.FileUtil;
import org.databene.commons.IOUtil;
import org.databene.commons.StringUtil;
import org.databene.script.ConstantScript;
import org.databene.script.Script;
import org.databene.script.ScriptDescriptor;
import org.databene.script.ScriptFactory;
import org.databene.script.ScriptLevel;
import org.databene.script.jsr223.Jsr223ScriptFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptUtil {
    private static final Logger configLogger = LoggerFactory.getLogger((String)"org.databene.CONFIG");
    private static String defaultScriptEngine = "ftl";
    private static Map<String, ScriptFactory> factories;
    private static final String SETUP_FILE_NAME = "org/databene/script/script.properties";
    private static Map<String, Script> scriptsByName;

    public static Object execute(Script script, Context context) {
        return script.evaluate(context);
    }

    public static Object evaluate(String text, Context context) {
        String trimmedText = text.trim();
        if (trimmedText.startsWith("{{") && trimmedText.endsWith("}}")) {
            return trimmedText.substring(1, trimmedText.length() - 1);
        }
        if (ScriptUtil.isScript(trimmedText)) {
            Script script = ScriptUtil.parseUnspecificText(text);
            return ScriptUtil.execute(script, context);
        }
        return text;
    }

    public static Script readFile(String uri) throws IOException {
        Script script = scriptsByName.get(uri);
        if (script == null) {
            String engineId = FileUtil.suffix((String)uri);
            ScriptFactory factory = ScriptUtil.getFactory(engineId);
            script = factory.readFile(uri);
            scriptsByName.put(uri, script);
        }
        return script;
    }

    public static Script parseUnspecificText(String text) {
        if (ScriptUtil.isScript(text)) {
            return ScriptUtil.parseScriptText(text.substring(1, text.length() - 1), false);
        }
        return new ConstantScript(text);
    }

    public static boolean isScript(String text) {
        if (StringUtil.isEmpty((CharSequence)text)) {
            return false;
        }
        String trimmedText = text.trim();
        return trimmedText.startsWith("{") && trimmedText.endsWith("}");
    }

    public static Script parseScriptText(String text) {
        return ScriptUtil.parseScriptText(text, true);
    }

    public static Script parseScriptText(String text, boolean removeBrackets) {
        String[] tokens;
        String engineId;
        if (text == null) {
            return null;
        }
        if (removeBrackets && text.startsWith("{") && text.endsWith("}")) {
            text = text.substring(1, text.length() - 1);
        }
        if (ScriptUtil.getFactory(engineId = (tokens = StringUtil.splitOnFirstSeparator((String)text, (char)':'))[0]) != null) {
            String scriptText = tokens[1];
            return ScriptUtil.parseScriptText(scriptText, engineId);
        }
        return ScriptUtil.parseScriptText(text, ScriptUtil.getDefaultScriptEngine());
    }

    public static Script parseScriptText(String text, String engineId) {
        if (engineId == null) {
            throw new IllegalArgumentException("engineId is null");
        }
        ScriptFactory factory = ScriptUtil.getFactory(engineId);
        if (factory != null) {
            return factory.parseText(text);
        }
        return new ConstantScript(text);
    }

    public static void addFactory(String name, ScriptFactory factory) {
        factories.put(name, factory);
    }

    public static String getDefaultScriptEngine() {
        return defaultScriptEngine;
    }

    public static void setDefaultScriptEngine(String defaultScriptEngine) {
        if (factories.get(defaultScriptEngine) == null) {
            throw new RuntimeException("Unknown script engine id: " + defaultScriptEngine);
        }
        ScriptUtil.defaultScriptEngine = defaultScriptEngine;
    }

    public static String combineScriptableParts(String ... parts) {
        String scriptEngine = ScriptUtil.getCommonScriptEngine(parts);
        boolean template = "ftl".equals(scriptEngine);
        boolean language = scriptEngine != null && !template;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            if (i > 0 && language) {
                builder.append(" + ");
            }
            String part = parts[i];
            ScriptDescriptor descriptor = new ScriptDescriptor(part);
            if (descriptor.level != ScriptLevel.NONE || !language) {
                builder.append(descriptor.text);
                continue;
            }
            builder.append("'").append(descriptor.text).append("'");
        }
        if (scriptEngine != null) {
            builder.insert(0, '{');
            if (!ScriptUtil.getDefaultScriptEngine().equals(scriptEngine)) {
                builder.insert(1, scriptEngine + ":");
            }
            builder.append('}');
        }
        return builder.toString();
    }

    static String getCommonScriptEngine(String ... parts) {
        ScriptDescriptor[] descriptors = ScriptUtil.describe(parts);
        for (int i = 0; i < parts.length; ++i) {
            if (descriptors[i].scriptEngine == null) continue;
            return descriptors[i].scriptEngine;
        }
        return null;
    }

    static ScriptDescriptor[] describe(String ... parts) {
        ScriptDescriptor[] descriptors = new ScriptDescriptor[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            descriptors[i] = new ScriptDescriptor(parts[i]);
        }
        return descriptors;
    }

    static ScriptFactory getFactory(String engineId) {
        return factories.get(engineId);
    }

    private static void parseConfigFile() {
        String className = null;
        try {
            ScriptFactory factory;
            factories = new HashMap<String, ScriptFactory>();
            try {
                ScriptEngineManager mgr = new ScriptEngineManager();
                for (ScriptEngineFactory scriptEngineFactory : mgr.getEngineFactories()) {
                    factory = new Jsr223ScriptFactory(scriptEngineFactory.getScriptEngine());
                    List<String> names = scriptEngineFactory.getNames();
                    for (String name : names) {
                        ScriptUtil.addFactory(name, factory);
                    }
                }
            }
            catch (NoClassDefFoundError e) {
                configLogger.error("Java 6/JSR 223 script engines not available, deactivating script engine support.");
            }
            configLogger.debug("Initializing Script mapping from file org/databene/script/script.properties");
            Map properties = IOUtil.readProperties((String)SETUP_FILE_NAME);
            for (Map.Entry entry : properties.entrySet()) {
                className = ((String)entry.getValue()).toString();
                factory = (ScriptFactory)BeanUtil.newInstance((String)className);
                ScriptUtil.addFactory(((String)entry.getKey()).toString(), factory);
            }
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationError("Setup file not found: org/databene/script/script.properties", (Throwable)e);
        }
        catch (IOException e) {
            throw new ConfigurationError("I/O Error while reading file: org/databene/script/script.properties", (Throwable)e);
        }
    }

    static {
        ScriptUtil.parseConfigFile();
        scriptsByName = new WeakHashMap<String, Script>();
    }
}

