/*
 * Decompiled with CFR 0.152.
 */
package org.databene.script;

import org.databene.commons.StringUtil;
import org.databene.script.ScriptLevel;
import org.databene.script.ScriptUtil;

public class ScriptDescriptor {
    public final String scriptEngine;
    public final ScriptLevel level;
    public final String text;

    public ScriptDescriptor(String text) {
        if (text != null && text.startsWith("{") && text.endsWith("}")) {
            String[] tokens = StringUtil.splitOnFirstSeparator((String)(text = text.substring(1, text.length() - 1)), (char)':');
            if (tokens.length > 1 && ScriptUtil.getFactory(tokens[0]) != null) {
                this.scriptEngine = tokens[0];
                this.text = tokens[1];
            } else {
                this.scriptEngine = ScriptUtil.getDefaultScriptEngine();
                this.text = text;
            }
            this.level = ScriptLevel.SCRIPT;
        } else {
            this.scriptEngine = null;
            this.level = ScriptLevel.NONE;
            this.text = text;
        }
    }
}

