/*
 * Decompiled with CFR 0.152.
 */
package org.databene.regex;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.ParserRuleReturnScope;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.databene.commons.Assert;
import org.databene.commons.CharSet;
import org.databene.commons.CollectionUtil;
import org.databene.commons.LocaleUtil;
import org.databene.commons.StringUtil;
import org.databene.commons.SyntaxError;
import org.databene.regex.Choice;
import org.databene.regex.CustomCharClass;
import org.databene.regex.Factor;
import org.databene.regex.Group;
import org.databene.regex.Quantifier;
import org.databene.regex.Sequence;
import org.databene.regex.antlr.RegexLexer;
import org.databene.regex.antlr.RegexParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegexParser.class);
    private Locale locale;

    public RegexParser() {
        this(LocaleUtil.getFallbackLocale());
    }

    public RegexParser(Locale locale) {
        this.locale = locale;
    }

    public static Set<Character> charsOfPattern(String pattern, Locale locale) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern is null");
        }
        Object regex = new RegexParser(locale).parseSingleChar(pattern);
        return RegexParser.toSet(regex);
    }

    public Object parseRegex(String pattern) throws SyntaxError {
        if (pattern == null) {
            return null;
        }
        if (pattern.length() == 0) {
            return "";
        }
        try {
            RegexLexer lex = new RegexLexer((CharStream)new ANTLRReaderStream((Reader)new StringReader(pattern)));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lex);
            org.databene.regex.antlr.RegexParser parser = new org.databene.regex.antlr.RegexParser((TokenStream)tokens);
            RegexParser.expression_return r = parser.expression();
            RegexParser.checkForSyntaxErrors(pattern, "regex", parser, r);
            if (r != null) {
                CommonTree tree = (CommonTree)r.getTree();
                LOGGER.debug("parsed {} to {}", (Object)pattern, (Object)tree.toStringTree());
                return this.convertNode(tree);
            }
            return null;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof RecognitionException) {
                throw this.mapToSyntaxError((RecognitionException)e.getCause(), pattern);
            }
            throw e;
        }
        catch (IOException e) {
            throw new IllegalStateException("Encountered illegal state in regex parsing", e);
        }
        catch (RecognitionException e) {
            throw this.mapToSyntaxError(e, pattern);
        }
    }

    public Object parseSingleChar(String pattern) throws SyntaxError {
        if (pattern == null) {
            return null;
        }
        if (pattern.length() == 0) {
            return "";
        }
        try {
            RegexLexer lex = new RegexLexer((CharStream)new ANTLRReaderStream((Reader)new StringReader(pattern)));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lex);
            org.databene.regex.antlr.RegexParser parser = new org.databene.regex.antlr.RegexParser((TokenStream)tokens);
            RegexParser.singlechar_return r = parser.singlechar();
            if (parser.getNumberOfSyntaxErrors() > 0) {
                throw new SyntaxError("Illegal regex", pattern);
            }
            if (r != null) {
                CommonTree tree = (CommonTree)r.getTree();
                LOGGER.debug("parsed {} to {}", (Object)pattern, (Object)tree.toStringTree());
                return this.convertNode(tree);
            }
            return null;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof RecognitionException) {
                throw this.mapToSyntaxError((RecognitionException)e.getCause(), pattern);
            }
            throw e;
        }
        catch (IOException e) {
            throw new IllegalStateException("Encountered illegal state in regex parsing", e);
        }
        catch (RecognitionException e) {
            throw this.mapToSyntaxError(e, pattern);
        }
    }

    public static CharSet toCharSet(Object o) {
        if (o instanceof CharSet) {
            return (CharSet)o;
        }
        if (o instanceof Character) {
            return new CharSet(CollectionUtil.toSet((Object[])new Character[]{(Character)o}));
        }
        if (o instanceof CustomCharClass) {
            return ((CustomCharClass)o).getCharSet();
        }
        throw new IllegalArgumentException("Not a supported character regex type: " + o.getClass());
    }

    public static Set<Character> toSet(Object regex) {
        return RegexParser.toCharSet(regex).getSet();
    }

    private SyntaxError mapToSyntaxError(RecognitionException e, String parsedText) {
        return new SyntaxError("Error parsing regular expression: " + e.getMessage(), parsedText, e.charPositionInLine, e.line);
    }

    private Object convertNode(CommonTree node) throws SyntaxError {
        if (node == null) {
            return null;
        }
        if (node.getToken() == null) {
            return "";
        }
        switch (node.getType()) {
            case 15: {
                return this.convertChoice(node);
            }
            case 14: {
                return this.convertGroup(node);
            }
            case 16: {
                return this.convertSequence(node);
            }
            case 17: {
                return this.convertFactor(node);
            }
            case 12: {
                return this.convertSimpleQuantifier(node);
            }
            case 18: {
                return this.convertClass(node);
            }
            case 19: {
                return this.convertRange(node);
            }
            case 5: {
                return Character.valueOf(this.convertAlphanum(node));
            }
            case 6: {
                return Character.valueOf(this.convertAlphanum(node));
            }
            case 7: {
                return this.convertEscaped(node);
            }
            case 8: {
                return Character.valueOf(this.convertNonTypeable(node));
            }
            case 9: {
                return Character.valueOf(this.convertOctal(node));
            }
            case 10: {
                return Character.valueOf(this.convertHexChar(node));
            }
            case 11: {
                return Character.valueOf(this.convertCodedChar(node));
            }
            case 4: {
                return this.convertPredefClass(node);
            }
        }
        throw new SyntaxError("Unknown token type: " + node.getToken(), node.toString(), node.getCharPositionInLine(), node.getLine());
    }

    private Group convertGroup(CommonTree node) throws SyntaxError {
        List childNodes = node.getChildren();
        Assert.equals((Object)1, (Object)childNodes.size(), (String)"Group is expected to have exactly one child node");
        return new Group(this.convertNode((CommonTree)childNodes.get(0)));
    }

    private Choice convertChoice(CommonTree node) throws SyntaxError {
        List childNodes = node.getChildren();
        ArrayList<Object> childPatterns = new ArrayList<Object>();
        if (childNodes != null) {
            for (CommonTree childNode : childNodes) {
                childPatterns.add(this.convertNode(childNode));
            }
        }
        return new Choice(childPatterns.toArray());
    }

    private Sequence convertSequence(CommonTree tree) throws SyntaxError {
        List childNodes = tree.getChildren();
        ArrayList<Object> children = new ArrayList<Object>();
        if (childNodes != null) {
            for (CommonTree child : childNodes) {
                children.add(this.convertNode(child));
            }
        }
        return new Sequence(children.toArray());
    }

    private Factor convertFactor(CommonTree tree) throws SyntaxError {
        List children = tree.getChildren();
        Object subPattern = this.convertNode((CommonTree)children.get(0));
        Quantifier quantifier = null;
        quantifier = children.size() > 1 ? this.convertQuantifier((CommonTree)children.get(1)) : new Quantifier(1, 1);
        return new Factor(subPattern, quantifier);
    }

    private CustomCharClass convertClass(CommonTree node) throws SyntaxError {
        CustomCharClass result = new CustomCharClass();
        List childNodes = node.getChildren();
        if (childNodes != null) {
            for (CommonTree child : childNodes) {
                List gdChildren;
                if (child.getType() == 20) {
                    gdChildren = child.getChildren();
                    if (gdChildren == null) continue;
                    for (CommonTree gdChild : gdChildren) {
                        result.getIncluded().add(this.convertNode(gdChild));
                    }
                    continue;
                }
                gdChildren = child.getChildren();
                if (gdChildren == null) continue;
                for (CommonTree gdChild : gdChildren) {
                    result.getExcluded().add(this.convertNode(gdChild));
                }
            }
        }
        if (result.getIncluded().isEmpty()) {
            result.getIncluded().add(new CharSet().addAnyCharacters());
        }
        return result;
    }

    private char convertAlphanum(CommonTree node) {
        return node.getText().charAt(0);
    }

    private char convertNonTypeable(CommonTree node) throws SyntaxError {
        switch (node.getText().charAt(1)) {
            case 'r': {
                return '\r';
            }
            case 'n': {
                return '\n';
            }
            case 't': {
                return '\t';
            }
            case 'f': {
                return '\f';
            }
            case 'a': {
                return '\u0007';
            }
            case 'e': {
                return '\u001b';
            }
        }
        throw new SyntaxError("invalid non-typeable char", node.getText(), node.getCharPositionInLine(), node.getLine());
    }

    private char convertOctal(CommonTree node) {
        return (char)Integer.parseInt(node.getText().substring(2), 8);
    }

    private char convertHexChar(CommonTree node) {
        return (char)Integer.parseInt(node.getText().substring(2), 16);
    }

    private char convertCodedChar(CommonTree node) {
        return (char)(Character.toUpperCase(node.getText().charAt(2)) - 65);
    }

    private CharSet convertPredefClass(CommonTree node) throws SyntaxError {
        String text = node.getText();
        if (".".equals(text)) {
            return new CharSet(".", CharSet.getAnyCharacters());
        }
        char charClass = text.charAt(1);
        switch (charClass) {
            case 'd': {
                return new CharSet("\\d", CharSet.getDigits());
            }
            case 'D': {
                return new CharSet("\\D", CharSet.getNonDigits());
            }
            case 's': {
                return new CharSet("\\s", CharSet.getWhitespaces());
            }
            case 'S': {
                return new CharSet("\\S", CharSet.getNonWhitespaces());
            }
            case 'w': {
                return new CharSet("\\w", CharSet.getWordChars((Locale)this.locale));
            }
            case 'W': {
                return new CharSet("\\W", CharSet.getNonWordChars());
            }
        }
        throw new SyntaxError("Unsupported character class", text, node.getCharPositionInLine(), node.getLine());
    }

    private Character convertEscaped(CommonTree node) {
        String text = node.getText();
        return Character.valueOf(text.charAt(1));
    }

    private Object convertRange(CommonTree node) throws SyntaxError {
        List children = node.getChildren();
        CommonTree fromNode = (CommonTree)children.get(0);
        char from = ((Character)this.convertNode(fromNode)).charValue();
        CommonTree toNode = (CommonTree)children.get(1);
        char to = ((Character)this.convertNode(toNode)).charValue();
        return new CharSet(fromNode.getText() + "-" + toNode.getText(), from, to);
    }

    private Quantifier convertQuantifier(CommonTree node) throws SyntaxError {
        switch (node.getType()) {
            case 12: {
                return this.convertSimpleQuantifier(node);
            }
            case 22: {
                return this.convertExplicitQuantifier(node);
            }
        }
        throw new SyntaxError("Error parsing quantifier", node.getText(), node.getCharPositionInLine(), node.getLine());
    }

    private Quantifier convertExplicitQuantifier(CommonTree tree) {
        int min = 0;
        Integer max = null;
        List children = tree.getChildren();
        min = this.convertInt((CommonTree)children.get(0));
        if (children.size() > 1) {
            max = this.convertInt((CommonTree)children.get(1));
        }
        Quantifier result = new Quantifier(min, max);
        return result;
    }

    private Integer convertInt(CommonTree node) {
        Assert.equals((Object)13, (Object)node.getType(), (String)"node is not an integer");
        return Integer.parseInt(node.getText());
    }

    private Quantifier convertSimpleQuantifier(CommonTree node) throws SyntaxError {
        Assert.equals((Object)12, (Object)node.getType(), (String)"node is not an simple quantifier");
        char letter = node.getText().charAt(0);
        switch (letter) {
            case '?': {
                return new Quantifier(0, 1);
            }
            case '*': {
                return new Quantifier(0, null);
            }
            case '+': {
                return new Quantifier(1, null);
            }
        }
        throw new SyntaxError("Error parsing simple quantifier", node.getText(), node.getCharPositionInLine(), node.getLine());
    }

    private static void checkForSyntaxErrors(String text, String type, org.databene.regex.antlr.RegexParser parser, ParserRuleReturnScope r) {
        if (parser.getNumberOfSyntaxErrors() > 0) {
            throw new SyntaxError("Illegal " + type, text, -1, -1);
        }
        CommonToken stop = (CommonToken)r.stop;
        if (stop.getStopIndex() < StringUtil.trimRight((String)text).length() - 1) {
            if (stop.getStopIndex() == 0) {
                throw new SyntaxError("Syntax error after " + stop.getText(), text);
            }
            throw new SyntaxError("Syntax error", text);
        }
    }
}

