/*
 * Decompiled with CFR 0.152.
 */
package org.databene.regex;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.databene.commons.CharSet;
import org.databene.regex.RegexParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomCharClass {
    private List<?> included;
    private List<?> excluded;

    public CustomCharClass() {
        this(new ArrayList());
    }

    public CustomCharClass(List<?> included) {
        this(included, new ArrayList());
    }

    public CustomCharClass(List<?> included, List<?> excluded) {
        this.included = included;
        this.excluded = excluded;
    }

    public List<Object> getIncluded() {
        return this.included;
    }

    public void setIncluded(List<Object> included) {
        this.included = included;
    }

    public List<Object> getExcluded() {
        return this.excluded;
    }

    public void setExcluded(List<Object> excluded) {
        this.excluded = excluded;
    }

    public CharSet getCharSet() {
        CharSet result = new CharSet(this.toString(), new HashSet());
        for (Object incl : this.included) {
            result.addAll(RegexParser.toSet(incl));
        }
        for (Object excl : this.excluded) {
            result.removeAll(RegexParser.toSet(excl));
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.excluded == null ? 0 : ((Object)this.excluded).hashCode());
        result = 31 * result + (this.included == null ? 0 : ((Object)this.included).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomCharClass other = (CustomCharClass)obj;
        if (this.excluded == null ? other.excluded != null : !((Object)this.excluded).equals(other.excluded)) {
            return false;
        }
        return !(this.included == null ? other.included != null : !((Object)this.included).equals(other.included));
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[");
        this.appendToString(this.included, result);
        if (!this.excluded.isEmpty()) {
            result.append('^');
            this.appendToString(this.excluded, result);
        }
        return result.append(']').toString();
    }

    private void appendToString(List<?> objects, StringBuilder builder) {
        for (Object object : objects) {
            builder.append(object);
        }
    }
}

