/*
 * Decompiled with CFR 0.152.
 */
package org.databene.html;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.databene.commons.CollectionUtil;
import org.databene.commons.SystemInfo;
import org.databene.html.HTMLEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLUtil {
    private static final Set<String> EMPTY_TAGS = CollectionUtil.toSet((Object[])new String[]{"br", "img", "meta", "link"});
    public static final String DOCTYPE_401 = "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">";
    static final String[] BROWSERS = new String[]{"google-chrome", "firefox", "opera", "epiphany", "konqueror", "conkeror", "midori", "kazehakase", "mozilla", "netscape", "links", "lynx"};

    public static void openBrowser(String url) {
        try {
            Class<?> desktopClass = Class.forName("java.awt.Desktop");
            Method browseMethod = desktopClass.getDeclaredMethod("browse", URI.class);
            Method getDesktopMethod = desktopClass.getDeclaredMethod("getDesktop", new Class[0]);
            Object desktop = getDesktopMethod.invoke(null, new Object[0]);
            browseMethod.invoke(desktop, URI.create(url));
        }
        catch (Exception ignore) {
            try {
                if (SystemInfo.isMacOsx()) {
                    Class<?> fileManager = Class.forName("com.apple.eio.FileManager");
                    Method openUrlMethod = fileManager.getDeclaredMethod("openURL", String.class);
                    openUrlMethod.invoke(null, url);
                } else if (SystemInfo.isWindows()) {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                } else {
                    String browser = null;
                    for (String candidate : BROWSERS) {
                        if (browser != null || Runtime.getRuntime().exec(new String[]{"which", candidate}).getInputStream().read() == -1) continue;
                        browser = candidate;
                        Runtime.getRuntime().exec(new String[]{candidate, url});
                    }
                    if (browser == null) {
                        throw new RuntimeException("No browser found");
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error opening web browser with URL: " + url, e);
            }
        }
    }

    public static boolean isEmptyTag(String tagName) {
        return EMPTY_TAGS.contains(tagName.toLowerCase());
    }

    public static String unescape(String text) {
        int i;
        StringBuilder result = new StringBuilder(text.length());
        while ((i = text.indexOf(38)) >= 0) {
            HTMLEntity entity = HTMLEntity.getEntity(text, i);
            if (entity != null) {
                result.append(text.substring(0, i));
                if ("nbsp".equals(entity.htmlCode)) {
                    result.append(' ');
                } else if ("ndash".equals(entity.htmlCode)) {
                    result.append('-');
                } else {
                    result.append(entity.character);
                }
                text = text.substring(i + entity.htmlCode.length() + 2);
                continue;
            }
            result.append(text.substring(0, i));
            result.append("&");
            text = text.substring(i + 1);
        }
        result.append(text);
        return result.toString();
    }

    public static String escape(String value) {
        if (value == null) {
            return "";
        }
        value = value.replace("&", "&amp;");
        value = value.replace("<", "&lt;");
        value = value.replace(">", "&gt;");
        value = value.replace("'", "&#39;");
        value = value.replace("\"", "&quot;");
        return value;
    }

    public static Map<String, String> parseCGIParameters(String url) {
        String[] nvPairs;
        HashMap<String, String> result = new HashMap<String, String>();
        int qmIndex = url.indexOf(63);
        if (qmIndex >= 0) {
            url = url.substring(qmIndex + 1);
        }
        for (String nvPair : nvPairs = url.split("&")) {
            String[] tokens = nvPair.split("=");
            result.put(tokens[0], tokens[1]);
        }
        return result;
    }

    public static String td(String text) {
        return HTMLUtil.td(text, null, null);
    }

    public static String td(String text, String alignment) {
        return HTMLUtil.td(text, alignment);
    }

    public static String td(String text, String alignment, String style) {
        StringBuilder builder = new StringBuilder("<td");
        if (alignment != null) {
            builder.append(" align=\"").append(alignment).append('\"');
        }
        if (style != null) {
            builder.append(" style=\"").append(style).append('\"');
        }
        builder.append('>').append(text).append("</td>");
        return builder.toString();
    }

    public static String a(String href, String text) {
        return "<a href='" + href + "'>" + text + "</a>";
    }

    public static String aNewWindow(String href, String text) {
        return "<a href='" + href + "' target='_blank'>" + text + "</a>";
    }
}

