/*
 * Decompiled with CFR 0.152.
 */
package org.databene.html;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.ParseException;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.databene.commons.CollectionUtil;
import org.databene.commons.IOUtil;
import org.databene.commons.SystemInfo;
import org.databene.html.DefaultHTMLTokenizer;
import org.databene.html.HTMLEntity;
import org.databene.html.HTMLTokenizer;
import org.databene.html.HTMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTML2XML {
    private static final Logger LOGGER = LoggerFactory.getLogger(HTML2XML.class);
    private static final Set<String> COMMON_CODES = CollectionUtil.toSet((Object[])new String[]{"lt", "gt", "amp"});

    public static String convert(String html) throws ParseException {
        StringReader reader = new StringReader(html);
        StringWriter writer = new StringWriter();
        try {
            ConversionContext context = new ConversionContext(reader, writer, "UTF-8");
            HTML2XML.convert(context);
            String string = writer.getBuffer().toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtil.close((Closeable)reader);
        }
    }

    public static void convert(Reader reader, OutputStream out, String encoding) throws ParseException, UnsupportedEncodingException {
        OutputStreamWriter writer = new OutputStreamWriter(out, encoding);
        try {
            ConversionContext context = new ConversionContext(reader, writer, encoding);
            HTML2XML.convert(context);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtil.close((Closeable)reader);
            IOUtil.close((Closeable)writer);
        }
    }

    private static void convert(ConversionContext context) throws IOException, ParseException {
        int token;
        block9: while ((token = context.tokenizer.nextToken()) != -1) {
            switch (token) {
                case 2: 
                case 4: {
                    HTML2XML.ensureXmlHeader(context);
                    if ("script".equalsIgnoreCase(context.tokenizer.name())) continue block9;
                    String lcTagName = context.tokenizer.name().toLowerCase();
                    if (!"html".equals(lcTagName) && !context.rootCreated) {
                        HTML2XML.ensureRootElement(context);
                    } else {
                        String lastTagName;
                        if ("html".equals(lcTagName) && context.rootCreated) {
                            LOGGER.warn("Malformed HTML document: misplaced <HTML> element");
                            continue block9;
                        }
                        if (context.path.size() > 0 && HTMLUtil.isEmptyTag(lastTagName = context.path.peek()) && !context.tokenizer.name().equals(lastTagName)) {
                            context.writer.write("</" + lastTagName + '>');
                            context.path.pop();
                        }
                    }
                    context.rootCreated = true;
                    if (token == 4) {
                        HTML2XML.writeEmptyTag(context.writer, context.tokenizer);
                        continue block9;
                    }
                    HTML2XML.writeStartTag(context.writer, context.tokenizer);
                    context.path.push(context.tokenizer.name());
                    continue block9;
                }
                case 3: {
                    if ("script".equalsIgnoreCase(context.tokenizer.name())) continue block9;
                    boolean done = false;
                    if (HTML2XML.contains(context.path, context.tokenizer.name())) {
                        do {
                            String pathTagName = context.path.pop();
                            context.writer.write("</" + pathTagName + '>');
                            if (!pathTagName.equals(context.tokenizer.name())) continue;
                            done = true;
                        } while (!done);
                    }
                    if (!"html".equalsIgnoreCase(context.tokenizer.name())) continue block9;
                    return;
                }
                case 1: {
                    HTML2XML.ensureXmlHeader(context);
                    String text = context.tokenizer.text();
                    if (text != null && text.trim().length() > 0) {
                        HTML2XML.ensureRootElement(context);
                    }
                    HTML2XML.writeText(context.writer, text);
                    continue block9;
                }
                case 5: {
                    HTML2XML.ensureRootElement(context);
                    String comment = context.tokenizer.text();
                    int s = comment.indexOf("<!--") + "<!--".length();
                    int e = comment.lastIndexOf("-->");
                    comment = "<!--" + comment.substring(s, e).replace("--", "- ") + "-->";
                    HTML2XML.writeXml(context.writer, comment);
                    continue block9;
                }
                case 0: {
                    continue block9;
                }
                case 6: {
                    String piText = context.tokenizer.text();
                    HTML2XML.writeXml(context.writer, piText);
                    if (!piText.startsWith("<?xml")) continue block9;
                    context.xmlHeaderCreated = true;
                    continue block9;
                }
                case 7: {
                    continue block9;
                }
            }
            throw new UnsupportedOperationException("Unsupported token type: " + token);
        }
        while (context.path.size() > 0) {
            String tagName = context.path.pop();
            context.writer.write("</" + tagName + '>');
        }
    }

    private static void ensureXmlHeader(ConversionContext context) throws IOException {
        if (!context.xmlHeaderCreated) {
            context.writer.write("<?xml version=\"1.0\" encoding=\"" + context.encoding + "\"?>" + SystemInfo.getLineSeparator());
            context.xmlHeaderCreated = true;
        }
    }

    private static void ensureRootElement(ConversionContext context) throws IOException {
        HTML2XML.ensureXmlHeader(context);
        if (!context.rootCreated && !"html".equals(context.tokenizer.name())) {
            HTML2XML.writeStartTag(context.writer, "html");
            context.path.push("html");
            context.rootCreated = true;
        }
    }

    private static boolean contains(Stack<String> path, String name) {
        for (String tagName : path) {
            if (!tagName.equals(name)) continue;
            return true;
        }
        return false;
    }

    private static void writeEmptyTag(Writer writer, HTMLTokenizer tokenizer) throws IOException {
        writer.write('<' + tokenizer.name());
        HTML2XML.writeAttributes(writer, tokenizer);
        writer.write("/>");
    }

    private static void writeStartTag(Writer writer, HTMLTokenizer tokenizer) throws IOException {
        writer.write('<' + tokenizer.name());
        HTML2XML.writeAttributes(writer, tokenizer);
        writer.write(62);
    }

    private static void writeStartTag(Writer writer, String name) throws IOException {
        writer.write('<' + name + '>');
    }

    private static void writeAttributes(Writer writer, HTMLTokenizer tokenizer) throws IOException {
        for (Map.Entry<String, String> entry : tokenizer.attributes().entrySet()) {
            String value = entry.getValue();
            int quote = 34;
            if (value == null) {
                value = "";
            } else if (value.contains("\"")) {
                quote = 39;
            }
            writer.write(32);
            writer.write(entry.getKey());
            writer.write(61);
            writer.write(quote);
            HTML2XML.writeText(writer, value);
            writer.write(quote);
        }
    }

    private static void writeXml(Writer writer, String s) throws IOException {
        s = HTML2XML.resolveEntities(writer, s);
        writer.write(s);
    }

    private static void writeText(Writer writer, String s) throws IOException {
        s = s.replace("<", "&lt;");
        s = s.replace(">", "&gt;");
        s = HTML2XML.resolveEntities(writer, s);
        writer.write(s);
    }

    private static String resolveEntities(Writer writer, String s) throws IOException {
        int i;
        while ((i = s.indexOf(38)) >= 0) {
            HTMLEntity entity = HTMLEntity.getEntity(s, i);
            if (entity != null) {
                writer.write(s.substring(0, i + 1));
                if (COMMON_CODES.contains(entity.htmlCode)) {
                    writer.write(entity.htmlCode + ';');
                } else {
                    writer.write("#" + entity.xmlCode + ";");
                }
                s = s.substring(s.indexOf(59, i) + 1);
                continue;
            }
            writer.write(s.substring(0, i));
            writer.write("&amp;");
            s = s.substring(i + 1);
        }
        return s;
    }

    private static class ConversionContext {
        public String encoding;
        Writer writer;
        HTMLTokenizer tokenizer;
        Stack<String> path;
        boolean xmlHeaderCreated;
        boolean rootCreated;

        ConversionContext(Reader reader, Writer writer, String encoding) {
            this.tokenizer = new DefaultHTMLTokenizer(reader);
            this.path = new Stack();
            this.xmlHeaderCreated = false;
            this.rootCreated = false;
            this.writer = writer;
            this.encoding = encoding;
        }
    }
}

