/*
 * Decompiled with CFR 0.152.
 */
package org.databene.document.xls;

import java.io.IOException;
import org.databene.document.xls.XLSLineIterator;
import org.databene.webdecs.DataIterator;
import org.databene.webdecs.DataSource;
import org.databene.webdecs.OrthogonalArrayIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XLSSource
implements DataSource<Object[]> {
    private String uri;
    private String emptyMarker;
    private String nullMarker;
    private boolean rowBased;

    public XLSSource(String uri, String emptyMarker, String nullMarker, boolean rowBased) {
        this.uri = uri;
        this.emptyMarker = emptyMarker;
        this.nullMarker = nullMarker;
        this.rowBased = rowBased;
    }

    @Override
    public Class<Object[]> getType() {
        return Object[].class;
    }

    @Override
    public DataIterator<Object[]> iterator() {
        try {
            XLSLineIterator iterator = new XLSLineIterator(this.uri);
            if (this.emptyMarker != null) {
                iterator.setEmptyMarker(this.emptyMarker);
            }
            if (this.nullMarker != null) {
                iterator.setNullMarker(this.nullMarker);
            }
            if (!this.rowBased) {
                return new OrthogonalArrayIterator(iterator);
            }
            return iterator;
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating iterator for " + this.uri, e);
        }
    }

    @Override
    public void close() {
    }
}

