/*
 * Decompiled with CFR 0.152.
 */
package org.databene.document.xls;

import java.io.IOException;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.databene.commons.Converter;
import org.databene.commons.IOUtil;
import org.databene.commons.converter.NoOpConverter;
import org.databene.document.xls.HSSFUtil;
import org.databene.webdecs.DataContainer;
import org.databene.webdecs.DataIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XLSLineIterator
implements DataIterator<Object[]> {
    private String emptyMarker = "'";
    private String nullMarker;
    private Iterator<Row> rowIterator;
    private Converter<String, ?> stringPreprocessor;

    public XLSLineIterator(String uri) throws IOException {
        this(uri, 0);
    }

    public XLSLineIterator(String uri, int sheetIndex) throws IOException {
        this(uri, sheetIndex, null);
    }

    public XLSLineIterator(String uri, int sheetIndex, Converter<String, ?> preprocessor) throws IOException {
        this(XLSLineIterator.sheet(uri, sheetIndex), preprocessor);
    }

    public XLSLineIterator(String uri, String sheetName) throws IOException {
        this(XLSLineIterator.sheet(uri, sheetName), null);
    }

    public XLSLineIterator(HSSFSheet sheet, Converter<String, ?> stringPreprocessor) {
        if (stringPreprocessor == null) {
            stringPreprocessor = new NoOpConverter();
        }
        this.stringPreprocessor = stringPreprocessor;
        this.rowIterator = sheet.rowIterator();
        if (!this.rowIterator.hasNext()) {
            this.close();
            return;
        }
    }

    public String getEmptyMarker() {
        return this.emptyMarker;
    }

    public void setEmptyMarker(String emptyMarker) {
        this.emptyMarker = emptyMarker;
    }

    public String getNullMarker() {
        return this.nullMarker;
    }

    public void setNullMarker(String nullMarker) {
        this.nullMarker = nullMarker;
    }

    @Override
    public Class<Object[]> getType() {
        return Object[].class;
    }

    @Override
    public synchronized DataContainer<Object[]> next(DataContainer<Object[]> wrapper) {
        if (this.rowIterator == null || !this.rowIterator.hasNext()) {
            return null;
        }
        Row row = this.rowIterator.next();
        int cellCount = row.getLastCellNum();
        Object[] result = new Object[cellCount];
        for (int cellnum = 0; cellnum < cellCount; ++cellnum) {
            result[cellnum] = HSSFUtil.resolveCellValue(row.getCell(cellnum), this.emptyMarker, this.nullMarker, this.stringPreprocessor);
        }
        return wrapper.setData(result);
    }

    @Override
    public synchronized void close() {
        this.rowIterator = null;
    }

    private static HSSFSheet sheet(String uri, String sheetName) throws IOException {
        HSSFSheet sheet;
        HSSFWorkbook workbook = new HSSFWorkbook(IOUtil.getInputStreamForURI((String)uri));
        HSSFSheet hSSFSheet = sheet = sheetName != null ? workbook.getSheet(sheetName) : workbook.getSheetAt(0);
        if (sheet == null) {
            throw new IllegalArgumentException("Sheet not found in file " + uri + ": " + sheetName);
        }
        return sheet;
    }

    private static HSSFSheet sheet(String uri, int sheetIndex) throws IOException {
        HSSFWorkbook workbook = new HSSFWorkbook(IOUtil.getInputStreamForURI((String)uri));
        return workbook.getSheetAt(sheetIndex);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.rowIterator + "]";
    }
}

