/*
 * Decompiled with CFR 0.152.
 */
package org.databene.document.xls;

import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HSSFUtil {
    private HSSFUtil() {
    }

    public static Object resolveCellValue(Cell cell) {
        return HSSFUtil.resolveCellValue(cell, "'", null, null);
    }

    public static Object resolveCellValue(Cell cell, String emptyMarker, String nullMarker, Converter<String, ?> stringPreprocessor) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case 1: {
                return HSSFUtil.convertString(cell, emptyMarker, nullMarker, stringPreprocessor);
            }
            case 0: {
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue();
                }
                return cell.getNumericCellValue();
            }
            case 4: {
                return cell.getBooleanCellValue();
            }
            case 3: 
            case 5: {
                return cell.getRichStringCellValue().getString();
            }
            case 2: {
                FormulaEvaluator evaluator = cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
                CellValue cellValue = evaluator.evaluate(cell);
                switch (cellValue.getCellType()) {
                    case 1: {
                        return HSSFUtil.convertString(cellValue, emptyMarker, stringPreprocessor);
                    }
                    case 0: {
                        return cellValue.getNumberValue();
                    }
                    case 4: {
                        return cellValue.getBooleanValue();
                    }
                    case 3: 
                    case 5: {
                        return null;
                    }
                }
                throw new IllegalStateException("Unexpected cell type: " + cellValue.getCellType());
            }
        }
        throw new ConfigurationError("Not a supported cell type: " + cell.getCellType());
    }

    private static Object convertString(CellValue cellValue, String emptyMarker, Converter<?, ?> stringPreprocessor) {
        String content = cellValue.getStringValue();
        if (content != null && (content.equals(emptyMarker) || content.equals("'"))) {
            content = "";
        }
        return stringPreprocessor != null ? stringPreprocessor.convert((Object)content) : content;
    }

    private static Object convertString(Cell cell, String emptyMarker, String nullMarker, Converter<?, ?> stringPreprocessor) {
        String content = cell.getRichStringCellValue().getString();
        if (content != null) {
            if (content.equals(emptyMarker) || content.equals("'")) {
                content = "";
            }
            if (content.equals(nullMarker)) {
                content = null;
            }
        }
        return stringPreprocessor != null ? stringPreprocessor.convert((Object)content) : content;
    }
}

