/*
 * Decompiled with CFR 0.152.
 */
package org.databene.document.properties;

import java.beans.PropertyDescriptor;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.FieldPosition;
import java.text.MessageFormat;
import org.databene.commons.BeanUtil;
import org.databene.commons.Context;
import org.databene.commons.ConversionException;
import org.databene.commons.Converter;
import org.databene.commons.StringUtil;
import org.databene.commons.SystemInfo;
import org.databene.commons.bean.BeanToPropertyArrayConverter;
import org.databene.commons.converter.ArrayConverter;
import org.databene.commons.converter.ConverterChain;
import org.databene.commons.converter.ToStringConverter;
import org.databene.script.AbstractScript;
import org.databene.script.Script;
import org.databene.script.ScriptException;
import org.databene.script.ScriptUtil;
import org.databene.script.ScriptedDocumentWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanPropertiesFileWriter<E>
extends ScriptedDocumentWriter<E> {
    public BeanPropertiesFileWriter(Writer out, String ... propertyNames) {
        this(out, null, (Script)null, (Script)null, propertyNames);
    }

    public BeanPropertiesFileWriter(Writer out, String prefixPattern, String headerScriptUrl, String footerScriptUrl, String ... propertyNames) throws IOException {
        this(out, prefixPattern, headerScriptUrl != null ? ScriptUtil.readFile(headerScriptUrl) : null, footerScriptUrl != null ? ScriptUtil.readFile(footerScriptUrl) : null, propertyNames);
    }

    public BeanPropertiesFileWriter(Writer out, String prefixPattern, Script headerScript, Script footerScript, String ... propertyNames) {
        super(out, headerScript, new PartScript(prefixPattern, propertyNames), footerScript);
    }

    public static <T> void persist(T bean, String filename) throws IOException {
        FileWriter out = new FileWriter(filename);
        BeanPropertiesFileWriter<T> writer = new BeanPropertiesFileWriter<T>((Writer)out, BeanPropertiesFileWriter.getPropertyNames(bean.getClass()));
        writer.writeHeader();
        writer.writeElement(bean);
        writer.close();
        out.close();
    }

    private static String[] getPropertyNames(Class<?> beanType) {
        PropertyDescriptor[] descriptors = BeanUtil.getPropertyDescriptors(beanType);
        String[] names = new String[descriptors.length];
        for (int i = 0; i < descriptors.length; ++i) {
            names[i] = descriptors[i].getName();
        }
        return names;
    }

    private static class PartScript
    extends AbstractScript {
        private static final String LINE_SEPARATOR = SystemInfo.getLineSeparator();
        private MessageFormat prefixFormat;
        private String[] propertyNames;
        private Converter<Object, String[]> converter;
        private int elementCount;
        private StringBuffer buffer;
        FieldPosition pos0 = new FieldPosition(0);

        public PartScript(String prefixPattern, String ... propertyNames) {
            this.prefixFormat = prefixPattern != null ? new MessageFormat(prefixPattern) : null;
            this.propertyNames = propertyNames;
            int length = propertyNames.length;
            Converter[] propertyConverters = new Converter[length];
            for (int i = 0; i < length; ++i) {
                propertyConverters[i] = new ToStringConverter();
            }
            this.converter = new ConverterChain(new Converter[]{new BeanToPropertyArrayConverter(propertyNames), new ArrayConverter(Object.class, String.class, propertyConverters)});
            this.elementCount = 0;
            this.buffer = new StringBuffer();
        }

        public void execute(Context context, Writer out) throws IOException, ScriptException {
            try {
                ++this.elementCount;
                String[] cells = (String[])this.converter.convert(context.get("part"));
                String prefix = "";
                if (this.prefixFormat != null) {
                    this.prefixFormat.format(new Integer[]{this.elementCount}, this.buffer, this.pos0);
                    prefix = this.buffer.toString();
                    this.buffer.delete(0, this.buffer.length());
                }
                for (int i = 0; i < cells.length; ++i) {
                    out.write(prefix);
                    out.write(this.propertyNames[i]);
                    out.write(61);
                    out.write(StringUtil.escape((String)cells[i]));
                    out.write(LINE_SEPARATOR);
                }
            }
            catch (ConversionException e) {
                throw new ScriptException(e);
            }
        }
    }
}

