/*
 * Decompiled with CFR 0.152.
 */
package org.databene.document.fixedwidth;

import java.io.IOException;
import java.io.Writer;
import java.text.Format;
import org.databene.commons.Context;
import org.databene.commons.ConversionException;
import org.databene.commons.Converter;
import org.databene.commons.SystemInfo;
import org.databene.commons.converter.ConverterChain;
import org.databene.commons.converter.FormatFormatConverter;
import org.databene.commons.converter.ToStringConverter;
import org.databene.commons.format.PadFormat;
import org.databene.document.fixedwidth.FixedWidthColumnDescriptor;
import org.databene.script.AbstractScript;
import org.databene.script.Script;
import org.databene.script.ScriptException;
import org.databene.script.ScriptUtil;
import org.databene.script.ScriptedDocumentWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayFixedWidthWriter<E>
extends ScriptedDocumentWriter<E[]> {
    public ArrayFixedWidthWriter(Writer out, FixedWidthColumnDescriptor ... descriptors) {
        this(out, (Script)null, (Script)null, descriptors);
    }

    public ArrayFixedWidthWriter(Writer out, String headerScriptUrl, String footerScriptUrl, FixedWidthColumnDescriptor ... descriptors) throws IOException {
        this(out, headerScriptUrl != null ? ScriptUtil.readFile(headerScriptUrl) : null, footerScriptUrl != null ? ScriptUtil.readFile(footerScriptUrl) : null, descriptors);
    }

    public ArrayFixedWidthWriter(Writer out, Script headerScript, Script footerScript, FixedWidthColumnDescriptor ... descriptors) {
        super(out, headerScript, new ArrayFixedWidthScript(descriptors), footerScript);
    }

    private static class ArrayFixedWidthScript
    extends AbstractScript {
        private Converter<Object, String>[] converters;

        public ArrayFixedWidthScript(FixedWidthColumnDescriptor[] descriptors) {
            this.converters = new Converter[descriptors.length];
            for (int i = 0; i < descriptors.length; ++i) {
                FixedWidthColumnDescriptor descriptor = descriptors[i];
                this.converters[i] = new ConverterChain(new Converter[]{new ToStringConverter(), new FormatFormatConverter(String.class, (Format)new PadFormat(descriptor.getWidth(), descriptor.getAlignment(), ' '), true)});
            }
        }

        public void execute(Context context, Writer out) throws IOException, ScriptException {
            try {
                Object[] cellsOfCurrentRow = (Object[])context.get("part");
                for (int i = 0; i < cellsOfCurrentRow.length; ++i) {
                    out.write((String)this.converters[i].convert(cellsOfCurrentRow[i]));
                }
                out.write(SystemInfo.getLineSeparator());
            }
            catch (ConversionException e) {
                throw new ScriptException(e);
            }
        }
    }
}

