/*
 * Decompiled with CFR 0.152.
 */
package org.databene.document.csv;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.databene.commons.Converter;
import org.databene.document.csv.CSVLineIterator;
import org.databene.webdecs.DataContainer;
import org.databene.webdecs.DataIterator;
import org.databene.webdecs.util.ThreadLocalDataContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertingCSVParser<E>
implements DataIterator<E> {
    private Converter<String[], E> rowConverter;
    private CSVLineIterator source;
    private ThreadLocalDataContainer<String[]> dataContainer = new ThreadLocalDataContainer();

    public ConvertingCSVParser(String uri, Converter<String[], E> rowConverter) throws IOException {
        this.source = new CSVLineIterator(uri);
        this.rowConverter = rowConverter;
    }

    @Override
    public Class<E> getType() {
        return this.rowConverter.getTargetType();
    }

    @Override
    public DataContainer<E> next(DataContainer<E> wrapper) {
        DataContainer<String[]> tmp = this.source.next((DataContainer)this.dataContainer.get());
        if (tmp == null) {
            return null;
        }
        return wrapper.setData(this.rowConverter.convert((Object)tmp.getData()));
    }

    @Override
    public void close() {
        this.source.close();
    }

    public static <T> List<T> parse(String uri, Converter<String[], T> rowConverter) throws IOException {
        return ConvertingCSVParser.parse(uri, rowConverter, new ArrayList());
    }

    public static <T> List<T> parse(String uri, Converter<String[], T> rowConverter, List<T> list) throws IOException {
        ConvertingCSVParser<T> parser = new ConvertingCSVParser<T>(uri, rowConverter);
        DataContainer<Object> container = new DataContainer();
        while ((container = parser.next(container)) != null) {
            list.add(container.getData());
        }
        return list;
    }
}

