/*
 * Decompiled with CFR 0.152.
 */
package org.databene.document.csv;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import org.databene.commons.BeanUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.IOUtil;
import org.databene.commons.UpdateFailedException;
import org.databene.commons.bean.PropertyMutatorFactory;
import org.databene.commons.mutator.NamedMutator;
import org.databene.document.csv.CSVLineIterator;
import org.databene.webdecs.DataContainer;
import org.databene.webdecs.DataIterator;
import org.databene.webdecs.util.ThreadLocalDataContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVToJavaBeanMapper<E>
implements DataIterator<E> {
    private CSVLineIterator iterator;
    private Class<E> type;
    private String emptyValue;
    private NamedMutator[] mutators;
    private ThreadLocalDataContainer<String[]> dataContainer = new ThreadLocalDataContainer();

    public CSVToJavaBeanMapper(Reader reader, Class<E> type) throws IOException {
        this(reader, type, ',', null);
    }

    public CSVToJavaBeanMapper(Reader reader, Class<E> type, char separator, String emptyValue) throws IOException {
        this.iterator = new CSVLineIterator(reader, separator);
        this.type = type;
        this.emptyValue = emptyValue;
        String[] attributeNames = this.iterator.next((DataContainer)this.dataContainer.get()).getData();
        this.mutators = new NamedMutator[attributeNames.length];
        for (int i = 0; i < attributeNames.length; ++i) {
            String attributeName = attributeNames[i];
            this.mutators[i] = PropertyMutatorFactory.getPropertyMutator(type, (String)attributeName, (boolean)false);
        }
    }

    @Override
    public Class<E> getType() {
        return this.type;
    }

    @Override
    public DataContainer<E> next(DataContainer<E> wrapper) {
        int i = 0;
        try {
            DataContainer<String[]> tmp = this.iterator.next((DataContainer)this.dataContainer.get());
            if (tmp == null) {
                return null;
            }
            String[] line = tmp.getData();
            Object bean = BeanUtil.newInstance(this.type, (Object[])new Object[0]);
            int columns = Math.min(line.length, this.mutators.length);
            for (i = 0; i < columns; ++i) {
                String value = line[i];
                if (value.length() == 0) {
                    value = this.emptyValue;
                }
                this.mutators[i].setValue(bean, (Object)value);
            }
            return wrapper.setData(bean);
        }
        catch (UpdateFailedException e) {
            throw new ConfigurationError("Failed to set property '" + this.mutators[i].getName() + "' on class " + this.type);
        }
    }

    @Override
    public void close() {
        IOUtil.close((Closeable)this.iterator);
    }
}

