/*
 * Decompiled with CFR 0.152.
 */
package org.databene.document.csv;

import java.io.IOException;
import org.databene.document.csv.CSVLineIterator;
import org.databene.webdecs.DataIterator;
import org.databene.webdecs.DataSource;
import org.databene.webdecs.OrthogonalArrayIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVSource
implements DataSource<String[]> {
    public static final char DEFAULT_SEPARATOR = ',';
    protected String uri;
    protected char separator;
    protected String encoding;
    protected boolean ignoreEmptyLines;
    private boolean rowBased;

    public CSVSource(String uri, char separator, String encoding, boolean ignoreEmptyLines, boolean rowBased) {
        this.uri = uri;
        this.separator = separator;
        this.encoding = encoding;
        this.ignoreEmptyLines = ignoreEmptyLines;
        this.rowBased = rowBased;
    }

    @Override
    public Class<String[]> getType() {
        return String[].class;
    }

    @Override
    public DataIterator<String[]> iterator() {
        try {
            DataIterator<String[]> result = new CSVLineIterator(this.uri, this.separator, this.ignoreEmptyLines, this.encoding);
            if (!this.rowBased) {
                result = new OrthogonalArrayIterator(result);
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating iterator for " + this.uri, e);
        }
    }

    @Override
    public void close() {
    }
}

