/*
 * Decompiled with CFR 0.152.
 */
package org.databene.document.csv;

import java.io.IOException;
import org.databene.commons.StringUtil;
import org.databene.document.csv.CSVLineIterator;
import org.databene.webdecs.DataContainer;
import org.databene.webdecs.util.DataIteratorAdapter;
import org.databene.webdecs.util.ThreadLocalDataContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVSingleColumIterator
extends DataIteratorAdapter<String[], String> {
    private static final char DEFAULT_SEPARATOR = ',';
    private int columnIndex;
    ThreadLocalDataContainer<String[]> rowContainer = new ThreadLocalDataContainer();

    public CSVSingleColumIterator(String uri, int columnIndex) throws IOException {
        this(uri, columnIndex, ',', false, "UTF-8");
    }

    public CSVSingleColumIterator(String uri, int columnIndex, char separator, boolean ignoreEmptyLines, String encoding) throws IOException {
        super(new CSVLineIterator(uri, separator, ignoreEmptyLines, encoding));
        if (StringUtil.isEmpty((CharSequence)uri)) {
            throw new IllegalArgumentException("URI is empty");
        }
        if (columnIndex < 0) {
            throw new IllegalArgumentException("Negative column index: " + columnIndex);
        }
        this.columnIndex = columnIndex;
    }

    @Override
    public Class<String> getType() {
        return String.class;
    }

    @Override
    public DataContainer<String> next(DataContainer<String> wrapper) {
        DataContainer tmp = this.source.next((DataContainer)this.rowContainer.get());
        if (tmp == null) {
            return null;
        }
        String[] nextRow = (String[])tmp.getData();
        return wrapper.setData(this.columnIndex < nextRow.length ? nextRow[this.columnIndex] : null);
    }
}

