/*
 * Decompiled with CFR 0.152.
 */
package org.databene.document.csv;

import org.databene.commons.ConfigurationError;
import org.databene.commons.SystemInfo;
import org.databene.document.csv.CSVCellIterator;
import org.databene.webdecs.DataIterator;
import org.databene.webdecs.util.AbstractDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVCellSource
extends AbstractDataSource<String> {
    private String uri;
    private char separator;
    private String encoding;

    public CSVCellSource() {
        this(null, ',');
    }

    public CSVCellSource(String uri, char separator) {
        this(uri, separator, SystemInfo.getFileEncoding());
    }

    public CSVCellSource(String uri, char separator, String encoding) {
        super(String.class);
        this.uri = uri;
        this.separator = separator;
        this.encoding = encoding;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @Override
    public DataIterator<String> iterator() {
        try {
            return new CSVCellIterator(this.uri, this.separator, this.encoding);
        }
        catch (Exception e) {
            throw new ConfigurationError((Throwable)e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.uri + ", '" + this.separator + "']";
    }
}

