/*
 * Decompiled with CFR 0.152.
 */
package org.databene.document.csv;

import java.io.IOException;
import org.databene.commons.ConversionException;
import org.databene.document.csv.CSVTokenType;
import org.databene.document.csv.CSVTokenizer;
import org.databene.webdecs.DataContainer;
import org.databene.webdecs.DataIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVCellIterator
implements DataIterator<String> {
    private String uri;
    private char separator;
    private CSVTokenizer tokenizer;

    public CSVCellIterator(String uri, char separator, String encoding) throws IOException {
        this.uri = uri;
        this.separator = separator;
        this.tokenizer = new CSVTokenizer(uri, separator, encoding);
        this.skipEOLs();
    }

    public String getUri() {
        return this.uri;
    }

    public char getSeparator() {
        return this.separator;
    }

    @Override
    public Class<String> getType() {
        return String.class;
    }

    @Override
    public DataContainer<String> next(DataContainer<String> wrapper) {
        if (this.tokenizer == null) {
            return null;
        }
        try {
            String result = this.tokenizer.cell;
            this.skipEOLs();
            if (this.tokenizer.ttype == CSVTokenType.EOF) {
                this.close();
            }
            return wrapper.setData(result);
        }
        catch (ConversionException e) {
            throw new RuntimeException(e);
        }
    }

    public void remove() {
        throw new UnsupportedOperationException("Operation not supported: remove()");
    }

    @Override
    public void close() {
        if (this.tokenizer != null) {
            this.tokenizer.close();
            this.tokenizer = null;
        }
    }

    private void skipEOLs() {
        try {
            do {
                this.tokenizer.next();
            } while (this.tokenizer.ttype == CSVTokenType.EOL);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

