/*
 * Decompiled with CFR 0.152.
 */
package org.databene.document.csv;

import java.io.IOException;
import java.io.Writer;
import org.databene.commons.BeanUtil;
import org.databene.commons.Context;
import org.databene.commons.ConversionException;
import org.databene.commons.Converter;
import org.databene.commons.bean.ArrayPropertyExtractor;
import org.databene.commons.bean.BeanToPropertyArrayConverter;
import org.databene.commons.converter.ArrayConverter;
import org.databene.commons.converter.ConverterChain;
import org.databene.commons.converter.ToStringConverter;
import org.databene.document.csv.CSVUtil;
import org.databene.script.AbstractScript;
import org.databene.script.ConstantScript;
import org.databene.script.Script;
import org.databene.script.ScriptException;
import org.databene.script.ScriptedDocumentWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanCSVWriter<E>
extends ScriptedDocumentWriter<E> {
    public BeanCSVWriter(Writer out, char separator, Class<E> beanClass) {
        this(out, separator, true, BeanCSVWriter.getPropertyNames(beanClass));
    }

    public BeanCSVWriter(Writer out, char separator, String ... propertyNames) {
        this(out, separator, true, propertyNames);
    }

    public BeanCSVWriter(Writer out, char separator, boolean headed, String ... propertyNames) {
        this(out, separator, headed ? new ConstantScript(CSVUtil.formatHeaderWithLineFeed(separator, propertyNames)) : null, null, propertyNames);
    }

    public BeanCSVWriter(Writer out, char separator, Script headerScript, Script footerScript, String ... propertyNames) {
        super(out, headerScript, new BeanCSVScript(propertyNames, separator), footerScript);
    }

    private static <T> String[] getPropertyNames(Class<T> beanClass) {
        Object[] descriptors = BeanUtil.getPropertyDescriptors(beanClass);
        return (String[])ArrayPropertyExtractor.convert((Object[])descriptors, (String)"name", String.class);
    }

    private static class BeanCSVScript
    extends AbstractScript {
        private char separator;
        private Converter<Object, String[]> converter;

        public BeanCSVScript(String[] propertyNames, char separator) {
            this.separator = separator;
            int length = propertyNames.length;
            Converter[] propertyConverters = new Converter[length];
            for (int i = 0; i < length; ++i) {
                propertyConverters[i] = new ToStringConverter();
            }
            this.converter = new ConverterChain(new Converter[]{new BeanToPropertyArrayConverter(propertyNames), new ArrayConverter(Object.class, String.class, propertyConverters)});
        }

        public void execute(Context context, Writer out) throws IOException, ScriptException {
            try {
                String[] cells = (String[])this.converter.convert(context.get("part"));
                CSVUtil.writeRow(out, this.separator, cells);
            }
            catch (ConversionException e) {
                throw new ScriptException(e);
            }
        }
    }
}

