/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.aspectj;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class AjcHelper {
    public static final String DEFAULT_INCLUDES = "**/*.java, **/*.aj";
    public static final String DEFAULT_EXCLUDES = "";

    public static String createClassPath(MavenProject project, List pluginArtifacts, List outDirs) {
        String cp = new String();
        Set classPathElements = Collections.synchronizedSet(new LinkedHashSet());
        Set dependencyArtifacts = project.getDependencyArtifacts();
        classPathElements.addAll(dependencyArtifacts == null ? Collections.EMPTY_SET : dependencyArtifacts);
        classPathElements.addAll(project.getArtifacts());
        classPathElements.addAll(pluginArtifacts == null ? Collections.EMPTY_LIST : pluginArtifacts);
        Iterator iter = classPathElements.iterator();
        while (iter.hasNext()) {
            Artifact classPathElement = (Artifact)iter.next();
            File artifact = classPathElement.getFile();
            if (null == artifact) continue;
            cp = cp + classPathElement.getFile().getAbsolutePath();
            cp = cp + File.pathSeparatorChar;
        }
        Iterator outIter = outDirs.iterator();
        while (outIter.hasNext()) {
            cp = cp + outIter.next();
            cp = cp + File.pathSeparatorChar;
        }
        if (cp.endsWith(DEFAULT_EXCLUDES + File.pathSeparatorChar)) {
            cp = cp.substring(0, cp.length() - 1);
        }
        cp = StringUtils.replace((String)cp, (String)"//", (String)"/");
        return cp;
    }

    public static Set getBuildFilesForAjdtFile(String ajdtBuildDefFile, File basedir) throws MojoExecutionException {
        LinkedHashSet result = new LinkedHashSet();
        Properties ajdtBuildProperties = new Properties();
        try {
            ajdtBuildProperties.load(new FileInputStream(new File(basedir, ajdtBuildDefFile)));
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Build properties file specified not found", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("IO Error reading build properties file specified", (Exception)e);
        }
        result.addAll(AjcHelper.resolveIncludeExcludeString((String)ajdtBuildProperties.get("src.includes"), basedir));
        Set exludes = AjcHelper.resolveIncludeExcludeString((String)ajdtBuildProperties.get("src.excludes"), basedir);
        result.removeAll(exludes);
        return result;
    }

    public static Set getBuildFilesForSourceDirs(List sourceDirs, String[] includes, String[] excludes) throws MojoExecutionException {
        LinkedHashSet result = new LinkedHashSet();
        Iterator it = sourceDirs.iterator();
        while (it.hasNext()) {
            try {
                String sourceDir = (String)it.next();
                if (!FileUtils.fileExists((String)sourceDir)) continue;
                result.addAll(FileUtils.getFileNames((File)new File(sourceDir), (String)(null == includes || 0 == includes.length ? DEFAULT_INCLUDES : AjcHelper.getAsCsv(includes)), (String)(null == excludes || 0 == excludes.length ? DEFAULT_EXCLUDES : AjcHelper.getAsCsv(excludes)), (boolean)true));
            }
            catch (IOException e) {
                throw new MojoExecutionException("IO Error resolving sourcedirs", (Exception)e);
            }
        }
        return result;
    }

    public static Set getWeaveSourceFiles(String[] weaveDirs) throws MojoExecutionException {
        HashSet result = new HashSet();
        for (int i = 0; i < weaveDirs.length; ++i) {
            String weaveDir = weaveDirs[i];
            if (!FileUtils.fileExists((String)weaveDir)) continue;
            try {
                result.addAll(FileUtils.getFileNames((File)new File(weaveDir), (String)"**/*.class", (String)DEFAULT_EXCLUDES, (boolean)true));
                continue;
            }
            catch (IOException e) {
                throw new MojoExecutionException("IO Error resolving weavedirs", (Exception)e);
            }
        }
        return result;
    }

    public static void writeBuildConfigToFile(List arguments, String fileName, File outputDir) throws IOException {
        FileUtils.forceMkdir((File)outputDir);
        File argFile = new File(outputDir, fileName);
        argFile.getParentFile().mkdirs();
        argFile.createNewFile();
        BufferedWriter writer = new BufferedWriter(new FileWriter(argFile));
        Iterator iter = arguments.iterator();
        while (iter.hasNext()) {
            writer.write((String)iter.next());
            writer.newLine();
        }
        writer.flush();
        writer.close();
    }

    public static List readBuildConfigFile(String fileName, File outputDir) throws IOException {
        ArrayList<String> arguments = new ArrayList<String>();
        File argFile = new File(outputDir, fileName);
        if (FileUtils.fileExists((String)argFile.getAbsolutePath())) {
            FileReader reader = new FileReader(argFile);
            BufferedReader bufRead = new BufferedReader(reader);
            String line = null;
            do {
                if (null == (line = bufRead.readLine())) continue;
                arguments.add(line);
            } while (null != line);
        }
        return arguments;
    }

    protected static String getAsCsv(String[] strings) {
        String csv = DEFAULT_EXCLUDES;
        if (null != strings) {
            for (int i = 0; i < strings.length; ++i) {
                csv = csv + strings[i];
                if (i >= strings.length - 1) continue;
                csv = csv + ",";
            }
        }
        return csv;
    }

    protected static Set resolveIncludeExcludeString(String input, File basedir) throws MojoExecutionException {
        LinkedHashSet inclExlSet = new LinkedHashSet();
        try {
            if (null == input || input.trim().equals(DEFAULT_EXCLUDES)) {
                return inclExlSet;
            }
            String[] elements = input.split(",");
            if (null != elements) {
                for (int i = 0; i < elements.length; ++i) {
                    String element = elements[i];
                    if (element.endsWith(".java") || element.endsWith(".aj")) {
                        inclExlSet.addAll(FileUtils.getFileNames((File)basedir, (String)element, (String)DEFAULT_EXCLUDES, (boolean)true));
                        continue;
                    }
                    File lookupBaseDir = new File(basedir, element);
                    if (!FileUtils.fileExists((String)lookupBaseDir.getAbsolutePath())) continue;
                    inclExlSet.addAll(FileUtils.getFileNames((File)lookupBaseDir, (String)DEFAULT_INCLUDES, (String)DEFAULT_EXCLUDES, (boolean)true));
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not resolve java or aspect sources to compile", (Exception)e);
        }
        return inclExlSet;
    }
}

