/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.model.dmn.impl;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.SchemaFactory;
import org.camunda.bpm.model.dmn.Dmn;
import org.camunda.bpm.model.dmn.DmnModelException;
import org.camunda.bpm.model.dmn.impl.DmnModelInstanceImpl;
import org.camunda.bpm.model.xml.ModelParseException;
import org.camunda.bpm.model.xml.impl.ModelImpl;
import org.camunda.bpm.model.xml.impl.parser.AbstractModelParser;
import org.camunda.bpm.model.xml.impl.util.ReflectUtil;
import org.camunda.bpm.model.xml.instance.DomDocument;

public class DmnParser
extends AbstractModelParser {
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";

    public DmnParser() {
        this.schemaFactory = SchemaFactory.newInstance(W3C_XML_SCHEMA);
        this.addSchema("http://www.omg.org/spec/DMN/20151101/dmn.xsd", this.createSchema("DMN11.xsd", DmnParser.class.getClassLoader()));
        this.addSchema("http://www.omg.org/spec/DMN/20151101/dmn11.xsd", this.createSchema("DMN11_Alternative.xsd", DmnParser.class.getClassLoader()));
    }

    protected void configureFactory(DocumentBuilderFactory dbf) {
        dbf.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
        dbf.setAttribute(JAXP_SCHEMA_SOURCE, new String[]{ReflectUtil.getResource((String)"DMN11.xsd", (ClassLoader)DmnParser.class.getClassLoader()).toString(), ReflectUtil.getResource((String)"DMN11_Alternative.xsd", (ClassLoader)DmnParser.class.getClassLoader()).toString()});
        super.configureFactory(dbf);
    }

    protected DmnModelInstanceImpl createModelInstance(DomDocument document) {
        return new DmnModelInstanceImpl((ModelImpl)Dmn.INSTANCE.getDmnModel(), Dmn.INSTANCE.getDmnModelBuilder(), document);
    }

    public DmnModelInstanceImpl parseModelFromStream(InputStream inputStream) {
        try {
            return (DmnModelInstanceImpl)super.parseModelFromStream(inputStream);
        }
        catch (ModelParseException e) {
            throw new DmnModelException("Unable to parse model", e);
        }
    }

    public DmnModelInstanceImpl getEmptyModel() {
        return (DmnModelInstanceImpl)super.getEmptyModel();
    }
}

