/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.springsupport.txn;

import com.avaje.ebean.config.ExternalTransactionManager;
import com.avaje.ebean.springsupport.txn.SpringJdbcTransaction;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.server.transaction.DefaultTransactionThreadLocal;
import com.avaje.ebeaninternal.server.transaction.TransactionManager;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SpringAwareJdbcTransactionManager
implements ExternalTransactionManager {
    private static final Logger logger = Logger.getLogger(SpringAwareJdbcTransactionManager.class.getName());
    private DataSource dataSource;
    private TransactionManager transactionManager;
    private String serverName;

    public void setTransactionManager(Object txnMgr) {
        this.transactionManager = (TransactionManager)txnMgr;
        this.dataSource = this.transactionManager.getDataSource();
        this.serverName = this.transactionManager.getServerName();
    }

    public Object getCurrentTransaction() {
        ConnectionHolder holder = (ConnectionHolder)TransactionSynchronizationManager.getResource((Object)this.dataSource);
        if (holder == null || !holder.isSynchronizedWithTransaction()) {
            SpiTransaction currentEbeanTransaction = DefaultTransactionThreadLocal.get((String)this.serverName);
            if (currentEbeanTransaction != null) {
                String msg = "SpringTransaction - no current spring txn BUT using current Ebean one " + currentEbeanTransaction.getId();
                logger.log(Level.WARNING, msg);
            } else if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Spring Txn - no current transaction ");
            }
            return currentEbeanTransaction;
        }
        SpringTxnListener springTxnLister = this.getSpringTxnListener();
        if (springTxnLister != null) {
            return springTxnLister.getTransaction();
        }
        SpringJdbcTransaction newTrans = new SpringJdbcTransaction(holder, this.transactionManager);
        springTxnLister = this.createSpringTxnListener(newTrans);
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)springTxnLister);
        DefaultTransactionThreadLocal.set((String)this.serverName, (SpiTransaction)newTrans);
        return newTrans;
    }

    private SpringTxnListener getSpringTxnListener() {
        List synchronizations;
        if (TransactionSynchronizationManager.isSynchronizationActive() && (synchronizations = TransactionSynchronizationManager.getSynchronizations()) != null) {
            for (int i = 0; i < synchronizations.size(); ++i) {
                if (!(synchronizations.get(i) instanceof SpringTxnListener)) continue;
                return (SpringTxnListener)((Object)synchronizations.get(i));
            }
        }
        return null;
    }

    private SpringTxnListener createSpringTxnListener(SpringJdbcTransaction t) {
        return new SpringTxnListener(this.transactionManager, t);
    }

    private static class SpringTxnListener
    extends TransactionSynchronizationAdapter {
        private final TransactionManager transactionManager;
        private final SpringJdbcTransaction transaction;
        private final String serverName;

        private SpringTxnListener(TransactionManager transactionManager, SpringJdbcTransaction t) {
            this.transactionManager = transactionManager;
            this.transaction = t;
            this.serverName = transactionManager.getServerName();
        }

        public SpringJdbcTransaction getTransaction() {
            return this.transaction;
        }

        public void beforeCommit(boolean readOnly) {
        }

        public void afterCompletion(int status) {
            switch (status) {
                case 0: {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Spring Txn [" + this.transaction.getId() + "] committed");
                    }
                    this.transactionManager.notifyOfCommit((SpiTransaction)this.transaction);
                    break;
                }
                case 1: {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Spring Txn [" + this.transaction.getId() + "] rollback");
                    }
                    this.transactionManager.notifyOfRollback((SpiTransaction)this.transaction, null);
                    break;
                }
                default: {
                    String msg = "Invalid status " + status;
                    throw new PersistenceException(msg);
                }
            }
            DefaultTransactionThreadLocal.replace((String)this.serverName, null);
        }
    }
}

