/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.atmosphere.util.FilterConfigImpl;

public final class AtmosphereFilterChain
implements FilterChain {
    public static final int INCREMENT = 20;
    private FilterConfigImpl[] filters = new FilterConfigImpl[20];
    private int n = 0;
    private Servlet servlet = null;
    private ServletConfig configImpl;

    public void init() throws ServletException {
        for (FilterConfigImpl f : this.filters) {
            if (f == null) continue;
            f.getFilter().init((FilterConfig)f);
        }
        if (this.servlet != null) {
            this.servlet.init(this.configImpl);
        }
    }

    public void invokeFilterChain(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        request.setAttribute("pos", (Object)new AtomicInteger(0));
        this.doFilter(request, response);
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        AtomicInteger pos = (AtomicInteger)request.getAttribute("pos");
        if (pos.get() < this.n) {
            FilterConfigImpl filterConfig = this.filters[pos.getAndIncrement()];
            Filter filter = null;
            try {
                filter = filterConfig.getFilter();
                filter.doFilter(request, response, (FilterChain)this);
            }
            catch (IOException e) {
                throw e;
            }
            catch (ServletException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new ServletException("Throwable", e);
            }
            return;
        }
        try {
            if (this.servlet == null) {
                throw new ServletException("No Servlet Defined");
            }
            this.servlet.service(request, response);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServletException("Throwable", e);
        }
    }

    public void addFilter(FilterConfigImpl filterConfig) {
        if (filterConfig.getFilter() == null) {
            throw new NullPointerException("Filter is null");
        }
        if (this.n == this.filters.length) {
            FilterConfigImpl[] newFilters = new FilterConfigImpl[this.n + 20];
            System.arraycopy(this.filters, 0, newFilters, 0, this.n);
            this.filters = newFilters;
        }
        this.filters[this.n++] = filterConfig;
    }

    public void setServlet(ServletConfig configImpl, Servlet servlet) {
        this.configImpl = configImpl;
        this.servlet = servlet;
    }

    public FilterConfigImpl getFilter(int i) {
        return this.filters[i];
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public ServletConfig getServletConfig() {
        return this.configImpl;
    }

    public void destroy() {
        if (this.n > 0 && this.filters != null) {
            for (int i = 0; i < this.filters.length; ++i) {
                if (this.filters[i] == null) continue;
                this.filters[i].recycle();
            }
            this.filters = null;
        }
        if (this.servlet != null) {
            this.servlet.destroy();
        }
    }
}

