/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.ILocalVariable;
import org.aspectj.org.eclipse.jdt.core.IMethod;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.Signature;
import org.aspectj.org.eclipse.jdt.core.WorkingCopyOwner;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.core.CompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElement;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelManager;
import org.aspectj.org.eclipse.jdt.internal.core.LambdaMethod;
import org.aspectj.org.eclipse.jdt.internal.core.ResolvedLambdaExpression;
import org.aspectj.org.eclipse.jdt.internal.core.SourceType;
import org.aspectj.org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.aspectj.org.eclipse.jdt.internal.core.util.MementoTokenizer;
import org.aspectj.org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.core.runtime.IProgressMonitor;

public class LambdaExpression
extends SourceType {
    SourceTypeElementInfo elementInfo;
    LambdaMethod lambdaMethod;
    protected int sourceStart;
    protected int sourceEnd;
    protected int arrowPosition;
    protected String interphase;

    public LambdaExpression(JavaElement parent, org.aspectj.org.eclipse.jdt.internal.compiler.ast.LambdaExpression lambdaExpression) {
        super(parent, String.valueOf(new String("Lambda(")) + new String(lambdaExpression.resolvedType.sourceName()) + ')');
        this.sourceStart = lambdaExpression.sourceStart;
        this.sourceEnd = lambdaExpression.sourceEnd;
        this.arrowPosition = lambdaExpression.arrowPosition;
        this.interphase = new String(CharOperation.replaceOnCopy(lambdaExpression.resolvedType.genericTypeSignature(), '/', '.'));
        this.elementInfo = LambdaExpression.makeTypeElementInfo(this, this.interphase, this.sourceStart, this.sourceEnd, this.arrowPosition);
        this.lambdaMethod = LambdaMethod.make(this, lambdaExpression);
        this.elementInfo.children = new IJavaElement[]{this.lambdaMethod};
    }

    public LambdaExpression(JavaElement parent, String name, String interphase, int sourceStart, int sourceEnd, int arrowPosition) {
        super(parent, name);
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
        this.arrowPosition = arrowPosition;
        this.interphase = interphase;
        this.sourceStart = sourceStart;
        this.elementInfo = LambdaExpression.makeTypeElementInfo(this, interphase, this.sourceStart, sourceEnd, arrowPosition);
    }

    public LambdaExpression(JavaElement parent, String name, String interphase, int sourceStart, int sourceEnd, int arrowPosition, LambdaMethod lambdaMethod) {
        super(parent, name);
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
        this.arrowPosition = arrowPosition;
        this.interphase = interphase;
        this.sourceStart = sourceStart;
        this.elementInfo = LambdaExpression.makeTypeElementInfo(this, interphase, this.sourceStart, sourceEnd, arrowPosition);
        IJavaElement[] iJavaElementArray = new IJavaElement[1];
        this.lambdaMethod = lambdaMethod;
        iJavaElementArray[0] = this.lambdaMethod;
        this.elementInfo.children = iJavaElementArray;
    }

    private static SourceTypeElementInfo makeTypeElementInfo(LambdaExpression handle, String interphase, int sourceStart, int sourceEnd, int arrowPosition) {
        SourceTypeElementInfo elementInfo = new SourceTypeElementInfo();
        elementInfo.setFlags(0);
        elementInfo.setHandle(handle);
        elementInfo.setSourceRangeStart(sourceStart);
        elementInfo.setSourceRangeEnd(sourceEnd);
        elementInfo.setNameSourceStart(sourceStart);
        elementInfo.setNameSourceEnd(arrowPosition);
        elementInfo.setSuperclassName(null);
        elementInfo.addCategories(handle, null);
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        char[][] superinterfaces = new char[][]{manager.intern(Signature.toString(interphase).toCharArray())};
        elementInfo.setSuperInterfaceNames(superinterfaces);
        return elementInfo;
    }

    @Override
    protected void closing(Object info) throws JavaModelException {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LambdaExpression) {
            LambdaExpression that = (LambdaExpression)o;
            if (this.sourceStart != that.sourceStart) {
                return false;
            }
            CompilationUnit thisCU = (CompilationUnit)this.getCompilationUnit();
            CompilationUnit thatCU = (CompilationUnit)that.getCompilationUnit();
            return thisCU.getElementName().equals(thatCU.getElementName()) && thisCU.parent.equals(thatCU.parent);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Util.combineHashCodes(super.hashCode(), this.sourceStart);
    }

    @Override
    public Object getElementInfo(IProgressMonitor monitor) throws JavaModelException {
        return this.elementInfo;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return ')';
    }

    @Override
    protected void getHandleMemento(StringBuffer buff) {
        this.getHandleMemento(buff, true);
    }

    protected void getHandleMemento(StringBuffer buff, boolean memoizeParent) {
        if (memoizeParent) {
            ((JavaElement)this.getParent()).getHandleMemento(buff);
        }
        buff.append(this.getHandleMementoDelimiter());
        this.escapeMementoName(buff, this.name);
        buff.append('\"');
        this.escapeMementoName(buff, this.interphase);
        buff.append('!');
        buff.append(this.sourceStart);
        buff.append('!');
        buff.append(this.sourceEnd);
        buff.append('!');
        buff.append(this.arrowPosition);
    }

    @Override
    public IJavaElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner workingCopyOwner) {
        if (token.charAt(0) != '&') {
            return null;
        }
        if (!memento.hasMoreTokens()) {
            return this;
        }
        String selector = memento.nextToken();
        if (!memento.hasMoreTokens() || memento.nextToken().charAt(0) != '!') {
            return this;
        }
        if (!memento.hasMoreTokens()) {
            return this;
        }
        int length = Integer.parseInt(memento.nextToken());
        String[] parameterTypes = new String[length];
        String[] parameterNames = new String[length];
        int i = 0;
        while (i < length) {
            if (!memento.hasMoreTokens() || memento.nextToken().charAt(0) != '\"') {
                return this;
            }
            parameterTypes[i] = memento.nextToken();
            if (!memento.hasMoreTokens() || memento.nextToken().charAt(0) != '\"') {
                return this;
            }
            parameterNames[i] = memento.nextToken();
            ++i;
        }
        if (!memento.hasMoreTokens() || memento.nextToken().charAt(0) != '\"') {
            return this;
        }
        String returnType = memento.nextToken();
        if (!memento.hasMoreTokens() || memento.nextToken().charAt(0) != '\"') {
            return this;
        }
        String key = memento.nextToken();
        this.lambdaMethod = LambdaMethod.make(this, selector, key, this.sourceStart, this.sourceEnd, this.arrowPosition, parameterTypes, parameterNames, returnType);
        ILocalVariable[] parameters = new ILocalVariable[length];
        int i2 = 0;
        while (i2 < length) {
            parameters[i2] = (ILocalVariable)this.lambdaMethod.getHandleFromMemento(memento, workingCopyOwner);
            ++i2;
        }
        this.lambdaMethod.elementInfo.arguments = parameters;
        this.elementInfo.children = new IJavaElement[]{this.lambdaMethod};
        return this.lambdaMethod;
    }

    @Override
    public IJavaElement[] getChildren() throws JavaModelException {
        return new IJavaElement[]{this.lambdaMethod};
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public JavaElement resolved(Binding binding) {
        ResolvedLambdaExpression resolvedHandle = new ResolvedLambdaExpression(this.parent, this, new String(binding.computeUniqueKey()));
        return resolvedHandle;
    }

    public IMethod getMethod() {
        return this.lambdaMethod;
    }

    @Override
    public IJavaElement getPrimaryElement(boolean checkOwner) {
        CompilationUnit cu;
        if (checkOwner && ((cu = (CompilationUnit)this.getAncestor(5)) == null || cu.isPrimary())) {
            return this;
        }
        IJavaElement primaryParent = this.parent.getPrimaryElement(false);
        if (primaryParent instanceof JavaElement) {
            JavaElement ancestor = (JavaElement)primaryParent;
            StringBuffer buffer = new StringBuffer(32);
            this.getHandleMemento(buffer, false);
            this.lambdaMethod.getHandleMemento(buffer, false);
            String memento = buffer.toString();
            return ancestor.getHandleFromMemento(new MementoTokenizer(memento), DefaultWorkingCopyOwner.PRIMARY).getParent();
        }
        return this;
    }

    @Override
    public String[] getSuperInterfaceTypeSignatures() throws JavaModelException {
        return new String[]{this.interphase};
    }
}

